/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff.runtime;

import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Pipe;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.Tag;
import com.dyuproject.protostuff.runtime.DefaultIdStrategy;
import com.dyuproject.protostuff.runtime.HasSchema;
import com.dyuproject.protostuff.runtime.IdStrategy;
import com.dyuproject.protostuff.runtime.MappedSchema;
import com.dyuproject.protostuff.runtime.RuntimeEnv;
import com.dyuproject.protostuff.runtime.RuntimeFieldFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class RuntimeSchema<T>
extends MappedSchema<T> {
    private static final Set<String> NO_EXCLUSIONS = Collections.emptySet();
    public final RuntimeEnv.Instantiator<T> instantiator;

    public static <T> boolean map(Class<? super T> baseClass, Class<T> typeClass) {
        if (RuntimeEnv.ID_STRATEGY instanceof DefaultIdStrategy) {
            return ((DefaultIdStrategy)RuntimeEnv.ID_STRATEGY).map(baseClass, typeClass);
        }
        throw new RuntimeException("RuntimeSchema.map is only supported on DefaultIdStrategy");
    }

    public static <T> boolean register(Class<T> typeClass) {
        if (RuntimeEnv.ID_STRATEGY instanceof DefaultIdStrategy) {
            return ((DefaultIdStrategy)RuntimeEnv.ID_STRATEGY).registerPojo(typeClass);
        }
        throw new RuntimeException("RuntimeSchema.register is only supported on DefaultIdStrategy");
    }

    public static <T> boolean register(Class<T> typeClass, Schema<T> schema) {
        if (RuntimeEnv.ID_STRATEGY instanceof DefaultIdStrategy) {
            return ((DefaultIdStrategy)RuntimeEnv.ID_STRATEGY).registerPojo(typeClass, schema);
        }
        throw new RuntimeException("RuntimeSchema.register is only supported on DefaultIdStrategy");
    }

    public static boolean isRegistered(Class<?> typeClass) {
        return RuntimeSchema.isRegistered(typeClass, RuntimeEnv.ID_STRATEGY);
    }

    public static boolean isRegistered(Class<?> typeClass, IdStrategy strategy) {
        return strategy.isRegistered(typeClass);
    }

    public static <T> Schema<T> getSchema(Class<T> typeClass) {
        return RuntimeSchema.getSchema(typeClass, RuntimeEnv.ID_STRATEGY);
    }

    public static <T> Schema<T> getSchema(Class<T> typeClass, IdStrategy strategy) {
        return strategy.getSchemaWrapper(typeClass, true).getSchema();
    }

    static <T> HasSchema<T> getSchemaWrapper(Class<T> typeClass) {
        return RuntimeSchema.getSchemaWrapper(typeClass, RuntimeEnv.ID_STRATEGY);
    }

    static <T> HasSchema<T> getSchemaWrapper(Class<T> typeClass, IdStrategy strategy) {
        return strategy.getSchemaWrapper(typeClass, true);
    }

    public static <T> RuntimeSchema<T> createFrom(Class<T> typeClass) {
        return RuntimeSchema.createFrom(typeClass, NO_EXCLUSIONS, RuntimeEnv.ID_STRATEGY);
    }

    public static <T> RuntimeSchema<T> createFrom(Class<T> typeClass, IdStrategy strategy) {
        return RuntimeSchema.createFrom(typeClass, NO_EXCLUSIONS, strategy);
    }

    public static <T> RuntimeSchema<T> createFrom(Class<T> typeClass, String[] exclusions, IdStrategy strategy) {
        HashSet<String> set = new HashSet<String>();
        String[] stringArray = exclusions;
        int n = exclusions.length;
        int n2 = 0;
        while (n2 < n) {
            String exclusion = stringArray[n2];
            set.add(exclusion);
            ++n2;
        }
        return RuntimeSchema.createFrom(typeClass, set, strategy);
    }

    public static <T> RuntimeSchema<T> createFrom(Class<T> typeClass, Set<String> exclusions, IdStrategy strategy) {
        if (typeClass.isInterface() || Modifier.isAbstract(typeClass.getModifiers())) {
            throw new RuntimeException("The root object can neither be an abstract class nor interface: \"" + typeClass.getName());
        }
        Map<String, Field> fieldMap = RuntimeSchema.findInstanceFields(typeClass);
        ArrayList<MappedSchema.Field<T>> fields = new ArrayList<MappedSchema.Field<T>>(fieldMap.size());
        int i = 0;
        int maxFieldMapping = 0;
        boolean annotated = false;
        for (Field f : fieldMap.values()) {
            String name;
            int fieldMapping;
            if (exclusions.contains(f.getName())) continue;
            if (f.getAnnotation(Deprecated.class) != null) {
                ++i;
                continue;
            }
            Tag tag = f.getAnnotation(Tag.class);
            if (tag == null) {
                if (annotated) {
                    throw new RuntimeException(String.valueOf(typeClass.getName()) + "::" + f.getName() + "is not annotated with @" + Tag.class.getSimpleName());
                }
                fieldMapping = ++i;
                name = f.getName();
            } else {
                if (!annotated && !fields.isEmpty()) {
                    throw new RuntimeException("When using annotation-based mapping, all fields must be annotated with @" + Tag.class.getSimpleName() + " <- " + typeClass.getName());
                }
                annotated = true;
                fieldMapping = tag.value();
                if (fieldMapping < 1) {
                    throw new RuntimeException("Invalid field number: " + fieldMapping + " on " + typeClass);
                }
                name = tag.alias().isEmpty() ? f.getName() : tag.alias();
            }
            MappedSchema.Field field = RuntimeFieldFactory.getFieldFactory(f.getType(), strategy).create(fieldMapping, name, f, strategy);
            fields.add(field);
            maxFieldMapping = Math.max(maxFieldMapping, fieldMapping);
        }
        if (fields.isEmpty()) {
            throw new RuntimeException("Not able to map any fields from " + typeClass + ".  All fields are either transient/static.");
        }
        return new RuntimeSchema<T>(typeClass, fields, maxFieldMapping, RuntimeEnv.newInstantiator(typeClass));
    }

    public static <T> RuntimeSchema<T> createFrom(Class<T> typeClass, Map<String, String> declaredFields, IdStrategy strategy) {
        if (typeClass.isInterface() || Modifier.isAbstract(typeClass.getModifiers())) {
            throw new RuntimeException("The root object can neither be an abstract class nor interface: \"" + typeClass.getName());
        }
        ArrayList<MappedSchema.Field<T>> fields = new ArrayList<MappedSchema.Field<T>>(declaredFields.size());
        int i = 0;
        for (Map.Entry<String, String> entry : declaredFields.entrySet()) {
            Field f;
            try {
                f = typeClass.getDeclaredField(entry.getKey());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Exception on field: " + entry.getKey(), e);
            }
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isTransient(mod)) continue;
            MappedSchema.Field field = RuntimeFieldFactory.getFieldFactory(f.getType(), strategy).create(++i, entry.getValue(), f, strategy);
            fields.add(field);
        }
        if (fields.isEmpty()) {
            throw new RuntimeException("Not able to map any fields from " + typeClass + ".  All fields are either transient/static.");
        }
        return new RuntimeSchema<T>(typeClass, fields, i, RuntimeEnv.newInstantiator(typeClass));
    }

    static Map<String, Field> findInstanceFields(Class<?> typeClass) {
        LinkedHashMap<String, Field> fieldMap = new LinkedHashMap<String, Field>();
        RuntimeSchema.fill(fieldMap, typeClass);
        return fieldMap;
    }

    static void fill(Map<String, Field> fieldMap, Class<?> typeClass) {
        if (Object.class != typeClass.getSuperclass()) {
            RuntimeSchema.fill(fieldMap, typeClass.getSuperclass());
        }
        Field[] fieldArray = typeClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            int mod = f.getModifiers();
            if (!Modifier.isStatic(mod) && !Modifier.isTransient(mod)) {
                fieldMap.put(f.getName(), f);
            }
            ++n2;
        }
    }

    public RuntimeSchema(Class<T> typeClass, Collection<MappedSchema.Field<T>> fields, int lastFieldNumber, Constructor<T> constructor) {
        this(typeClass, fields, lastFieldNumber, new RuntimeEnv.DefaultInstantiator<T>(constructor));
    }

    public RuntimeSchema(Class<T> typeClass, Collection<MappedSchema.Field<T>> fields, int lastFieldNumber, RuntimeEnv.Instantiator<T> instantiator) {
        super(typeClass, fields, lastFieldNumber);
        this.instantiator = instantiator;
    }

    public boolean isInitialized(T message) {
        return true;
    }

    public T newMessage() {
        return this.instantiator.newInstance();
    }

    static <T> Pipe.Schema<T> resolvePipeSchema(Schema<T> schema, Class<? super T> clazz, boolean throwIfNone) {
        if (Message.class.isAssignableFrom(clazz)) {
            try {
                Method m = clazz.getDeclaredMethod("getPipeSchema", new Class[0]);
                return (Pipe.Schema)m.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (MappedSchema.class.isAssignableFrom(schema.getClass())) {
            return ((MappedSchema)schema).pipeSchema;
        }
        if (throwIfNone) {
            throw new RuntimeException("No pipe schema for: " + clazz);
        }
        return null;
    }
}

