/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.ali.bean;

import com.egzosn.pay.ali.utils.AntCertificationUtil;
import com.egzosn.pay.common.bean.result.PayError;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.util.str.StringUtils;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CertEnvironment {
    private String rootCertContent;
    private String rootCertSN;
    private String merchantCertSN;
    private String aliPayPublicKeySN;
    private Map<String, String> cachedAliPayPublicKey = new ConcurrentHashMap<String, String>();

    public CertEnvironment(InputStream merchantCert, InputStream aliPayCert, InputStream aliPayRootCert) {
        if (null == merchantCert || null == aliPayCert || null == aliPayRootCert) {
            throw new PayErrorException((PayError)new PayException("", "\u8bc1\u4e66\u53c2\u6570merchantCert\u3001aliPayCert\u6216aliPayRootCert\u8bbe\u7f6e\u4e0d\u5b8c\u6574\u3002"));
        }
        this.rootCertContent = AntCertificationUtil.readFromInputStream(aliPayRootCert);
        this.rootCertSN = AntCertificationUtil.getRootCertSN(this.rootCertContent);
        this.merchantCertSN = AntCertificationUtil.getCertSN(AntCertificationUtil.readFromInputStream(merchantCert));
        String aliPayPublicCertContent = AntCertificationUtil.readFromInputStream(aliPayCert);
        this.aliPayPublicKeySN = AntCertificationUtil.getCertSN(aliPayPublicCertContent);
        this.cachedAliPayPublicKey.put(this.aliPayPublicKeySN, AntCertificationUtil.getCertPublicKey(aliPayPublicCertContent));
    }

    public String getRootCertSN() {
        return this.rootCertSN;
    }

    public String getMerchantCertSN() {
        return this.merchantCertSN;
    }

    public String getAliPayPublicKey(String sn) {
        if (StringUtils.isEmpty((CharSequence)sn)) {
            return this.cachedAliPayPublicKey.values().iterator().next();
        }
        if (this.cachedAliPayPublicKey.containsKey(sn)) {
            return this.cachedAliPayPublicKey.get(sn);
        }
        throw new PayErrorException((PayError)new PayException("", "\u652f\u4ed8\u5b9d\u516c\u94a5\u8bc1\u4e66[" + sn + "]\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6700\u65b0\u652f\u4ed8\u5b9d\u516c\u94a5\u8bc1\u4e66\u5e76\u66ff\u6362\u539f\u8bc1\u4e66\u6587\u4ef6"));
    }
}

