/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.ali.bean;

import com.egzosn.pay.common.bean.Order;
import com.egzosn.pay.common.util.Util;
import com.egzosn.pay.common.util.str.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class OrderSettle
implements Order {
    private String outRequestNo;
    private String tradeNo;
    private String transOut;
    private String transIn;
    private BigDecimal amount;
    private Integer amountPercentage;
    private String desc;
    private String operatorId;
    private Map<String, Object> attr;

    public String getOutRequestNo() {
        return this.outRequestNo;
    }

    public void setOutRequestNo(String outRequestNo) {
        this.outRequestNo = outRequestNo;
    }

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getTransOut() {
        return this.transOut;
    }

    public void setTransOut(String transOut) {
        this.transOut = transOut;
    }

    public String getTransIn() {
        return this.transIn;
    }

    public void setTransIn(String transIn) {
        this.transIn = transIn;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Integer getAmountPercentage() {
        return this.amountPercentage;
    }

    public void setAmountPercentage(Integer amountPercentage) {
        this.amountPercentage = amountPercentage;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getOperatorId() {
        return this.operatorId;
    }

    public void setOperatorId(String operatorId) {
        this.operatorId = operatorId;
    }

    public Map<String, Object> toRoyaltyParameters() {
        TreeMap<String, Object> royalty = new TreeMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)this.transOut)) {
            royalty.put("trans_out", this.transOut);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.transIn)) {
            royalty.put("trans_in", this.transIn);
        }
        if (null != this.amount) {
            royalty.put("amount", Util.conversionAmount((BigDecimal)this.amount));
        }
        if (null != this.amountPercentage) {
            royalty.put("amount_percentage", this.amountPercentage);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.desc)) {
            royalty.put(" desc", this.desc);
        }
        return royalty;
    }

    public Map<String, Object> toBizContent() {
        TreeMap<String, Object> bizContent = new TreeMap<String, Object>();
        bizContent.put("out_request_no", this.outRequestNo);
        bizContent.put("trade_no", this.tradeNo);
        bizContent.put("royalty_parameters", this.toRoyaltyParameters());
        if (StringUtils.isNotEmpty((CharSequence)this.operatorId)) {
            bizContent.put("operator_id", this.operatorId);
        }
        return bizContent;
    }

    public Map<String, Object> getAttrs() {
        if (null == this.attr) {
            this.attr = new HashMap<String, Object>();
        }
        return this.attr;
    }

    public Object getAttr(String key) {
        return this.getAttrs().get(key);
    }

    public void addAttr(String key, Object value) {
        this.getAttrs().put(key, value);
    }
}

