/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.ali.utils;

import com.egzosn.pay.common.bean.result.PayError;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.util.IOUtils;
import com.egzosn.pay.common.util.sign.encrypt.Base64;
import com.egzosn.pay.common.util.str.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AntCertificationUtil {
    private static final Log LOGGER = LogFactory.getLog(AntCertificationUtil.class);

    public static boolean isTrusted(String certContent, String rootCertContent) {
        X509Certificate[] certificates;
        try {
            certificates = AntCertificationUtil.readPemCertChain(certContent);
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u8bfb\u53d6\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
        ArrayList<X509Certificate> rootCerts = new ArrayList<X509Certificate>();
        try {
            X509Certificate[] certs = AntCertificationUtil.readPemCertChain(rootCertContent);
            rootCerts.addAll(Arrays.asList(certs));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u8bfb\u53d6\u6839\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
        return AntCertificationUtil.verifyCertChain(certificates, rootCerts.toArray(new X509Certificate[rootCerts.size()]));
    }

    private static boolean verifyCert(X509Certificate cert, X509Certificate[] rootCerts) {
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            LOGGER.error((Object)"\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671f", (Throwable)e);
            return false;
        }
        catch (CertificateNotYetValidException e) {
            LOGGER.error((Object)"\u8bc1\u4e66\u672a\u6fc0\u6d3b", (Throwable)e);
            return false;
        }
        HashMap<Principal, X509Certificate> subjectMap = new HashMap<Principal, X509Certificate>();
        for (X509Certificate root : rootCerts) {
            subjectMap.put(root.getSubjectDN(), root);
        }
        Principal issuerDN = cert.getIssuerDN();
        X509Certificate issuer = (X509Certificate)subjectMap.get(issuerDN);
        if (issuer == null) {
            LOGGER.error((Object)"\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u5931\u8d25");
            return false;
        }
        try {
            PublicKey publicKey = issuer.getPublicKey();
            AntCertificationUtil.verifySignature(publicKey, cert);
        }
        catch (PayErrorException e) {
            LOGGER.error((Object)"\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
            return false;
        }
        return true;
    }

    private static boolean verifyCertChain(X509Certificate[] certs, X509Certificate[] rootCerts) {
        boolean sorted = AntCertificationUtil.sortByDn(certs);
        if (!sorted) {
            LOGGER.error((Object)"\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u5931\u8d25\uff1a\u4e0d\u662f\u5b8c\u6574\u7684\u8bc1\u4e66\u94fe");
            return false;
        }
        X509Certificate prev = certs[0];
        boolean firstOK = AntCertificationUtil.verifyCert(prev, rootCerts);
        if (!firstOK || certs.length == 1) {
            return firstOK;
        }
        for (int i = 1; i < certs.length; ++i) {
            X509Certificate cert = certs[i];
            if (!AntCertificationUtil.checkValidity(cert)) {
                return false;
            }
            AntCertificationUtil.verifySignature(prev.getPublicKey(), cert);
            prev = cert;
        }
        return true;
    }

    private static boolean checkValidity(X509Certificate cert) {
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            LOGGER.error((Object)"\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671f");
            return false;
        }
        catch (CertificateNotYetValidException e) {
            LOGGER.error((Object)"\u8bc1\u4e66\u672a\u6fc0\u6d3b");
            return false;
        }
        return true;
    }

    private static void verifySignature(PublicKey publicKey, X509Certificate cert) {
        try {
            cert.verify(publicKey);
        }
        catch (GeneralSecurityException e) {
            throw new PayErrorException((PayError)new PayException("\u8bc1\u4e66\u6821\u9a8c\u5931\u8d25", e.getMessage()));
        }
    }

    private static boolean sortByDn(X509Certificate[] certs) {
        HashMap<Principal, X509Certificate> subjectMap = new HashMap<Principal, X509Certificate>();
        HashMap<Principal, X509Certificate> issuerMap = new HashMap<Principal, X509Certificate>();
        boolean hasSelfSignedCert = false;
        for (X509Certificate cert : certs) {
            if (AntCertificationUtil.isSelfSigned(cert)) {
                if (hasSelfSignedCert) {
                    return false;
                }
                hasSelfSignedCert = true;
            }
            Principal subjectDN = cert.getSubjectDN();
            Principal issuerDN = cert.getIssuerDN();
            subjectMap.put(subjectDN, cert);
            issuerMap.put(issuerDN, cert);
        }
        ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
        X509Certificate current = certs[0];
        AntCertificationUtil.addressingUp(subjectMap, certChain, current);
        AntCertificationUtil.addressingDown(issuerMap, certChain, current);
        if (certs.length != certChain.size()) {
            return false;
        }
        for (int i = 0; i < certChain.size(); ++i) {
            certs[i] = (X509Certificate)certChain.get(i);
        }
        return true;
    }

    private static boolean isSelfSigned(X509Certificate cert) {
        return cert.getSubjectDN().equals(cert.getIssuerDN());
    }

    private static void addressingUp(Map<Principal, X509Certificate> subjectMap, List<X509Certificate> certChain, X509Certificate current) {
        certChain.add(0, current);
        if (AntCertificationUtil.isSelfSigned(current)) {
            return;
        }
        Principal issuerDN = current.getIssuerDN();
        X509Certificate issuer = subjectMap.get(issuerDN);
        if (issuer == null) {
            return;
        }
        AntCertificationUtil.addressingUp(subjectMap, certChain, issuer);
    }

    private static void addressingDown(Map<Principal, X509Certificate> issuerMap, List<X509Certificate> certChain, X509Certificate current) {
        Principal subjectDN = current.getSubjectDN();
        X509Certificate subject = issuerMap.get(subjectDN);
        if (subject == null) {
            return;
        }
        if (AntCertificationUtil.isSelfSigned(subject)) {
            return;
        }
        certChain.add(subject);
        AntCertificationUtil.addressingDown(issuerMap, certChain, subject);
    }

    private static X509Certificate[] readPemCertChain(String cert) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(cert.getBytes());
        CertificateFactory factory = null;
        try {
            factory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certificates = factory.generateCertificates(inputStream);
            return certificates.toArray(new X509Certificate[certificates.size()]);
        }
        catch (CertificateException e) {
            LOGGER.error((Object)"\u63d0\u53d6\u6839\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static String getRootCertSN(String rootCertContent) {
        String rootCertSN = null;
        try {
            X509Certificate[] x509Certificates = AntCertificationUtil.readPemCertChain(rootCertContent);
            if (null == x509Certificates) {
                return null;
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (X509Certificate c : x509Certificates) {
                if (!c.getSigAlgOID().startsWith("1.2.840.113549.1.1")) continue;
                md.update((c.getIssuerX500Principal().getName() + c.getSerialNumber()).getBytes());
                String certSN = new BigInteger(1, md.digest()).toString(16);
                certSN = AntCertificationUtil.fillMD5(certSN);
                rootCertSN = StringUtils.isEmpty(rootCertSN) ? certSN : rootCertSN + "_" + certSN;
            }
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)"\u63d0\u53d6\u6839\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
        return rootCertSN;
    }

    public static String getCertSN(String certContent) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(certContent.getBytes());
            CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate cert = (X509Certificate)factory.generateCertificate(inputStream);
            return AntCertificationUtil.md5((cert.getIssuerX500Principal().getName() + cert.getSerialNumber()).getBytes());
        }
        catch (GeneralSecurityException e) {
            throw new PayErrorException((PayError)new PayException(" \u83b7\u53d6\u516c\u94a5\u8bc1\u4e66\u5e8f\u5217\u53f7\u5f02\u5e38", e.getMessage()));
        }
    }

    private static String md5(byte[] bytes) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new PayErrorException((PayError)new PayException("", e.getMessage()));
        }
        md.update(bytes);
        String certSN = new BigInteger(1, md.digest()).toString(16);
        certSN = AntCertificationUtil.fillMD5(certSN);
        return certSN;
    }

    private static String fillMD5(String md5) {
        return md5.length() == 32 ? md5 : AntCertificationUtil.fillMD5("0" + md5);
    }

    public static String getCertPublicKey(String certContent) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(certContent.getBytes());
            CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate cert = (X509Certificate)factory.generateCertificate(inputStream);
            return Base64.encode((byte[])cert.getPublicKey().getEncoded());
        }
        catch (GeneralSecurityException e) {
            throw new PayErrorException((PayError)new PayException(" \u63d0\u53d6\u516c\u94a5\u8bc1\u4e66\u4e2d\u7684\u516c\u94a5\u5f02\u5e38", e.getMessage()));
        }
    }

    public static String readFromInputStream(InputStream cert) {
        try {
            return new String(IOUtils.toByteArray((InputStream)cert), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new PayErrorException((PayError)new PayException("\u8bfb\u53d6\u8bc1\u4e66\u5f02\u5e38", e.getMessage()));
        }
    }

    static {
        Security.removeProvider("SunEC");
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

