/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.api;

import com.egzosn.pay.common.api.PayConfigStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;

public abstract class BasePayConfigStorage
implements PayConfigStorage {
    private Object attach;
    private String keyPrivate;
    private String keyPublic;
    private String notifyUrl;
    private String returnUrl;
    private String signType;
    private String inputCharset;
    private String payType;
    private volatile String accessToken;
    private volatile long expiresTime;
    private Lock accessTokenLock;
    private boolean isTest = false;
    private boolean certSign = false;
    private volatile Map<String, Object> attr;

    @Override
    public Object getAttach() {
        return this.attach;
    }

    public void setAttach(Object attach) {
        this.attach = attach;
    }

    @Override
    public String getKeyPrivate() {
        return this.keyPrivate;
    }

    public void setKeyPrivate(String keyPrivate) {
        this.keyPrivate = keyPrivate;
    }

    @Override
    public String getKeyPublic() {
        return this.keyPublic;
    }

    public void setKeyPublic(String keyPublic) {
        this.keyPublic = keyPublic;
    }

    @Override
    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    @Override
    public String getSignType() {
        return this.signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    @Override
    public String getInputCharset() {
        return this.inputCharset;
    }

    public void setInputCharset(String inputCharset) {
        this.inputCharset = inputCharset;
    }

    @Override
    public String getPayType() {
        return this.payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Lock getAccessTokenLock() {
        return this.accessTokenLock;
    }

    public long getExpiresTime() {
        return this.expiresTime;
    }

    public boolean isAccessTokenExpired() {
        return System.currentTimeMillis() > this.expiresTime;
    }

    @Override
    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.updateAccessToken(accessToken, System.currentTimeMillis() + (long)(expiresInSeconds - 600) * 1000L);
    }

    @Override
    public synchronized void updateAccessToken(String accessToken, long expiresTime) {
        this.accessToken = accessToken;
        this.expiresTime = expiresTime;
    }

    public void expireAccessToken() {
        this.expiresTime = 0L;
    }

    @Override
    public String getToken() {
        return null;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setExpiresTime(long expiresTime) {
        this.expiresTime = expiresTime;
    }

    public void setAccessTokenLock(Lock accessTokenLock) {
        this.accessTokenLock = accessTokenLock;
    }

    @Override
    public boolean isTest() {
        return this.isTest;
    }

    public void setTest(boolean test) {
        this.isTest = test;
    }

    public boolean isCertSign() {
        return this.certSign;
    }

    public void setCertSign(boolean certSign) {
        this.certSign = certSign;
    }

    @Override
    public Map<String, Object> getAttrs() {
        if (null == this.attr) {
            this.attr = new HashMap<String, Object>();
        }
        return this.attr;
    }

    @Override
    public Object getAttr(String key) {
        return this.getAttrs().get(key);
    }

    public void addAttr(String key, Object value) {
        this.getAttrs().put(key, value);
    }
}

