/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.api;

import com.egzosn.pay.common.api.PayErrorExceptionHandler;
import com.egzosn.pay.common.api.PayMessageHandler;
import com.egzosn.pay.common.api.PayMessageInterceptor;
import com.egzosn.pay.common.api.PayMessageRouter;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.PayMessage;
import com.egzosn.pay.common.bean.PayOutMessage;
import com.egzosn.pay.common.exception.PayErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

public class PayMessageRouterRule {
    private final PayMessageRouter routerBuilder;
    private boolean async = false;
    private String payType;
    private String[] transactionType;
    private String subject;
    private String rSubject;
    private String key;
    private String rValue;
    private boolean reEnter = false;
    private List<PayMessageHandler> handlers = new ArrayList<PayMessageHandler>();
    private List<PayMessageInterceptor> interceptors = new ArrayList<PayMessageInterceptor>();

    public PayMessageRouterRule(PayMessageRouter routerBuilder) {
        this.routerBuilder = routerBuilder;
    }

    public PayMessageRouterRule async(boolean async) {
        this.async = async;
        return this;
    }

    public PayMessageRouterRule payType(String payType) {
        this.payType = payType;
        return this;
    }

    public PayMessageRouterRule transactionType(String ... transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    public PayMessageRouterRule subject(String subject) {
        this.subject = subject;
        return this;
    }

    public PayMessageRouterRule rSubject(String regex) {
        this.rSubject = regex;
        return this;
    }

    public PayMessageRouterRule key2RValue(String key, String regex) {
        this.key = key;
        this.rValue = regex;
        return this;
    }

    public PayMessageRouterRule interceptor(PayMessageInterceptor interceptor) {
        return this.interceptor(interceptor, null);
    }

    public PayMessageRouterRule interceptor(PayMessageInterceptor interceptor, PayMessageInterceptor ... otherInterceptors) {
        this.interceptors.add(interceptor);
        if (otherInterceptors != null && otherInterceptors.length > 0) {
            for (PayMessageInterceptor i : otherInterceptors) {
                this.interceptors.add(i);
            }
        }
        return this;
    }

    public PayMessageRouterRule handler(PayMessageHandler handler) {
        return this.handler(handler, null);
    }

    public PayMessageRouterRule handler(PayMessageHandler handler, PayMessageHandler ... otherHandlers) {
        this.handlers.add(handler);
        if (otherHandlers != null && otherHandlers.length > 0) {
            for (PayMessageHandler i : otherHandlers) {
                this.handlers.add(i);
            }
        }
        return this;
    }

    public PayMessageRouter end() {
        this.routerBuilder.getRules().add(this);
        return this.routerBuilder;
    }

    public PayMessageRouter next() {
        this.reEnter = true;
        return this.end();
    }

    protected boolean test(PayMessage payMessage) {
        return !(this.payType != null && !this.payType.equals(payMessage.getPayType() == null ? null : payMessage.getPayType()) || this.transactionType != null && !this.equalsTransactionType(payMessage.getTransactionType()) || this.key != null && this.rValue != null && !Pattern.matches(this.rValue, payMessage.getPayMessage().get(this.key) == null ? "" : payMessage.getPayMessage().get(this.key).toString().trim()) || this.subject != null && !this.subject.equals(payMessage.getSubject() == null ? null : payMessage.getSubject().trim()) || this.rSubject != null && !Pattern.matches(this.rSubject, payMessage.getSubject() == null ? "" : payMessage.getSubject().trim()));
    }

    public boolean equalsTransactionType(String transactionType) {
        if (null == transactionType) {
            return false;
        }
        for (String type : this.getTransactionType()) {
            if (!type.toLowerCase().equals(transactionType.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected PayOutMessage service(PayMessage payMessage, PayService payService, PayErrorExceptionHandler exceptionHandler) {
        try {
            HashMap<String, Object> context = new HashMap<String, Object>();
            for (PayMessageInterceptor interceptor : this.interceptors) {
                if (interceptor.intercept(payMessage, context, payService)) continue;
                return payService.successPayOutMessage(payMessage);
            }
            PayOutMessage res = null;
            for (PayMessageHandler handler : this.handlers) {
                res = handler.handle(payMessage, context, payService);
            }
            return res;
        }
        catch (PayErrorException e) {
            exceptionHandler.handle(e);
            return null;
        }
    }

    public PayMessageRouter getRouterBuilder() {
        return this.routerBuilder;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public String getPayType() {
        return this.payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String[] getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String[] transactionType) {
        this.transactionType = transactionType;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getrValue() {
        return this.rValue;
    }

    public void setrValue(String rValue) {
        this.rValue = rValue;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getrSubject() {
        return this.rSubject;
    }

    public void setrSubject(String rSubject) {
        this.rSubject = rSubject;
    }

    public boolean isReEnter() {
        return this.reEnter;
    }

    public void setReEnter(boolean reEnter) {
        this.reEnter = reEnter;
    }

    public List<PayMessageHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<PayMessageHandler> handlers) {
        this.handlers = handlers;
    }

    public List<PayMessageInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<PayMessageInterceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

