/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.bean;

import com.egzosn.pay.common.api.CertStore;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.http.HttpRequestTemplate;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public enum CertStoreType implements CertStore
{
    NONE{

        @Override
        public InputStream getInputStream(Object cert) throws IOException {
            return null;
        }
    }
    ,
    PATH{

        @Override
        public InputStream getInputStream(Object cert) throws IOException {
            return new FileInputStream(new File((String)cert));
        }
    }
    ,
    CLASS_PATH{

        @Override
        public InputStream getInputStream(Object cert) throws IOException {
            return Thread.currentThread().getContextClassLoader().getResourceAsStream((String)cert);
        }
    }
    ,
    STR{

        @Override
        public InputStream getInputStream(Object cert) throws IOException {
            return new ByteArrayInputStream(((String)cert).getBytes("ISO-8859-1"));
        }
    }
    ,
    INPUT_STREAM{

        @Override
        public InputStream getInputStream(Object cert) throws IOException {
            return (InputStream)cert;
        }
    }
    ,
    URL{

        @Override
        public InputStream getInputStream(Object url) throws IOException {
            return new HttpRequestTemplate().getForObject((String)url, InputStream.class, new Object[0]);
        }
    }
    ,
    BEAN{

        @Override
        public InputStream getInputStream(Object beanClazz) throws IOException {
            try {
                Class<?> clazz = Class.forName((String)beanClazz);
                CertStore certStore = (CertStore)clazz.newInstance();
                return certStore.getInputStream(beanClazz);
            }
            catch (ReflectiveOperationException e) {
                throw new PayErrorException(new PayException("\u8bc1\u4e66\u83b7\u53d6\u5f02\u5e38", e.getMessage()));
            }
        }
    };

}

