/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps.internal;

import java.io.IOException;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class CopyInterceptor
implements Interceptor {
    static final String TAG = "okhttps-Async-Response-Copy";

    public static boolean notIn(List<Interceptor> list) {
        for (Interceptor item : list) {
            if (!(item instanceof CopyInterceptor)) continue;
            return false;
        }
        return true;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        String tag = (String)request.tag(String.class);
        if (tag == null || !tag.contains(TAG)) {
            return response;
        }
        ResponseBody body = response.body();
        String type = response.header("Content-Type");
        if (body == null || type != null && (type.contains("octet-stream") || type.contains("image") || type.contains("video") || type.contains("archive") || type.contains("word") || type.contains("xls") || type.contains("pdf"))) {
            return response;
        }
        return response.newBuilder().body(ResponseBody.create((MediaType)body.contentType(), (byte[])body.bytes())).build();
    }
}

