/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Add;
import jm.audio.synth.Envelope;
import jm.audio.synth.Noise;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Value;
import jm.audio.synth.Volume;

public final class AMNoiseInst
extends Instrument {
    private int sampleRate;
    private int channels;
    private float depth = 0.0f;

    public AMNoiseInst(int sampleRate, double depth) {
        this.sampleRate = sampleRate;
        this.channels = 1;
        this.depth = (float)depth;
    }

    public void createChain() {
        Noise noise = new Noise(this, 4, this.sampleRate, this.channels);
        Envelope modEnv = new Envelope((AudioObject)noise, new double[]{0.0, 0.0, 0.5, 1.0, 1.0, 1.0});
        Volume modVol = new Volume((AudioObject)modEnv, this.depth);
        Value offsetAmp = new Value((Instrument)this, this.sampleRate, this.channels, 0.5f);
        AudioObject[] grp1 = new AudioObject[]{modVol, offsetAmp};
        Add add = new Add(grp1);
        Oscillator carrier = new Oscillator(add, 0, 0);
        Envelope env = new Envelope((AudioObject)carrier, new double[]{0.0, 0.0, 0.5, 1.0, 1.0, 0.0});
        Volume vol = new Volume((AudioObject)env, 1.0f);
        StereoPan span = new StereoPan(vol);
        SampleOut sout = new SampleOut(span);
    }
}

