/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Add;
import jm.audio.synth.Envelope;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class AddMorphInst
extends Instrument {
    private int overtones = 10;
    private double[][] points = new double[this.overtones][6];
    private double[] freqVals = new double[]{1.0, 3.0, 5.0, 7.0, 9.0, 1.0, 2.8, 5.6, 8.4, 11.0};
    private double[] volVals = new double[]{1.0, 0.7, 0.5, 0.3, 0.2, 1.0, 0.7, 0.5, 0.3, 0.2};
    private double[] pointArray1 = new double[]{0.0, 0.0, 0.02, 1.0, 1.0, 0.0};
    private double[] pointArray2 = new double[]{0.0, 0.0, 0.98, 1.0, 1.0, 0.0};
    private float pan;
    private int sampleRate;
    private Oscillator[] osc;
    private Envelope[] env;
    private Volume[] vol;

    public AddMorphInst(int sampleRate) {
        int i;
        this.sampleRate = sampleRate;
        for (i = 0; i < 5; ++i) {
            this.points[i] = this.pointArray1;
        }
        for (i = 5; i < 10; ++i) {
            this.points[i] = this.pointArray2;
        }
    }

    public void createChain() {
        this.osc = new Oscillator[this.overtones];
        this.env = new Envelope[this.overtones];
        this.vol = new Volume[this.overtones];
        for (int i = 0; i < this.overtones; ++i) {
            this.osc[i] = new Oscillator(this, 0, this.sampleRate, 2);
            this.osc[i].setFrqRatio((float)this.freqVals[i]);
            this.env[i] = new Envelope((AudioObject)this.osc[i], this.points[i]);
            this.vol[i] = new Volume((AudioObject)this.env[i], (float)this.volVals[i]);
        }
        Add add = new Add(this.vol);
        StereoPan span = new StereoPan(add);
        SampleOut sout = new SampleOut(span);
    }
}

