/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Add;
import jm.audio.synth.Envelope;
import jm.audio.synth.Filter;
import jm.audio.synth.Oscillator;
import jm.audio.synth.Value;
import jm.audio.synth.Volume;

public final class LFOFilteredSquareInst
extends Instrument {
    private int sampleRate;
    private int filterCutoff;
    private int channels;
    private int modAmount;

    public LFOFilteredSquareInst(int sampleRate) {
        this(sampleRate, (int)((double)sampleRate * 0.2));
    }

    public LFOFilteredSquareInst(int sampleRate, int filterCutoff) {
        this(sampleRate, filterCutoff, (int)((double)filterCutoff * 0.9));
    }

    public LFOFilteredSquareInst(int sampleRate, int filterCutoff, int modAmount) {
        this(sampleRate, filterCutoff, modAmount, 1);
    }

    public LFOFilteredSquareInst(int sampleRate, int filterCutoff, int modAmount, int channels) {
        this.sampleRate = sampleRate;
        this.filterCutoff = filterCutoff;
        this.modAmount = modAmount;
        this.channels = channels;
    }

    public void createChain() {
        Oscillator osc = new Oscillator(this, 3, this.sampleRate, this.channels);
        Oscillator osc2 = new Oscillator(this, 3, this.sampleRate, this.channels);
        osc2.setFrqRatio(1.001f);
        Oscillator osc3 = new Oscillator(this, 3, this.sampleRate, this.channels);
        osc3.setFrqRatio(0.999f);
        Add add = new Add(new AudioObject[]{osc, osc2, osc3});
        Value modfreq = new Value((Instrument)this, this.sampleRate, this.channels, 0.3f);
        Oscillator sineMod = new Oscillator(modfreq, 1, 1);
        sineMod.setAmp(this.modAmount);
        Filter filt = new Filter(new AudioObject[]{add, sineMod}, (double)this.filterCutoff, 0);
        Envelope env = new Envelope((AudioObject)filt, new double[]{0.0, 0.0, 0.05, 1.0, 0.2, 0.3, 0.8, 0.2, 1.0, 0.0});
        Volume vol = new Volume(env);
        SampleOut sout = new SampleOut(vol);
    }
}

