/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Envelope;
import jm.audio.synth.Filter;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class LPFilterEnvInst
extends Instrument {
    private int sampleRate;
    private int filterCutoff;
    private int channels;

    public LPFilterEnvInst(int sampleRate) {
        this(sampleRate, (int)((double)sampleRate * 0.02), 1);
    }

    public LPFilterEnvInst(int sampleRate, int filterCutoff) {
        this(sampleRate, filterCutoff, 1);
    }

    public LPFilterEnvInst(int sampleRate, int filterCutoff, int channels) {
        this.sampleRate = sampleRate;
        this.filterCutoff = filterCutoff;
        this.channels = channels;
    }

    public void createChain() {
        Envelope filtEnv = new Envelope((Instrument)this, this.sampleRate, this.channels, new double[]{0.0, 0.0, 0.2, (double)this.sampleRate * 0.4, 0.4, 0.0, 0.6, (double)this.sampleRate * 0.3, 1.0, (double)this.filterCutoff * 0.1});
        Oscillator osc = new Oscillator(this, 2, this.sampleRate, this.channels);
        Filter filt = new Filter(new AudioObject[]{osc, filtEnv}, (double)this.filterCutoff, 0);
        Envelope env = new Envelope((AudioObject)filt, new double[]{0.0, 0.0, 0.05, 1.0, 1.0, 0.0});
        Volume vol = new Volume(env);
        StereoPan pan = new StereoPan(vol);
        SampleOut sout = new SampleOut(pan);
    }
}

