/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Add;
import jm.audio.synth.Envelope;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class OvertoneInst
extends Instrument {
    private int channels;
    private int sampleRate;

    public OvertoneInst(int sampleRate) {
        this.sampleRate = sampleRate;
        this.channels = 2;
    }

    public void createChain() {
        Oscillator osc0 = new Oscillator(this, 0, this.sampleRate, this.channels);
        Volume vol0 = new Volume((AudioObject)osc0, 1.0f);
        Oscillator osc1 = new Oscillator(this, 0, this.sampleRate, this.channels);
        osc1.setFrqRatio(2.0);
        Volume vol1 = new Volume((AudioObject)osc1, 0.5f);
        Oscillator osc2 = new Oscillator(this, 0, this.sampleRate, this.channels);
        osc2.setFrqRatio(3.0);
        Volume vol2 = new Volume((AudioObject)osc2, 0.25f);
        Oscillator osc3 = new Oscillator(this, 0, this.sampleRate, this.channels);
        osc3.setFrqRatio(3.0);
        Volume vol3 = new Volume((AudioObject)osc3, 0.025f);
        AudioObject[] overtones = new AudioObject[]{vol0, vol1, vol2, vol3};
        Add adder = new Add(overtones);
        Envelope env = new Envelope((AudioObject)adder, new double[]{0.0, 0.0, 0.1, 1.0, 1.0, 0.0});
        StereoPan span = new StereoPan(env);
        SampleOut sout = new SampleOut(span);
    }
}

