/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleIn;
import jm.audio.io.SampleOut;
import jm.audio.synth.EnvPoint;
import jm.audio.synth.Envelope;
import jm.audio.synth.NoteBufferReversed;
import jm.audio.synth.ReSample;
import jm.audio.synth.Volume;

public final class ReverseResampledInst
extends Instrument {
    private String fileName;
    private int numOfChannels;
    private double baseFreq;
    private boolean wholeFile;
    private EnvPoint[] pointArray = new EnvPoint[10];

    public ReverseResampledInst(String fileName) {
        this(fileName, 440.0);
    }

    public ReverseResampledInst(String fileName, double baseFreq) {
        this(fileName, baseFreq, false);
    }

    public ReverseResampledInst(String fileName, double baseFreq, boolean wholeFile) {
        this.fileName = fileName;
        this.baseFreq = baseFreq;
        this.wholeFile = wholeFile;
        EnvPoint[] tempArray = new EnvPoint[]{new EnvPoint(0.0f, 0.0f), new EnvPoint(0.1f, 1.0f), new EnvPoint(0.4f, 0.5f), new EnvPoint(0.9f, 0.3f), new EnvPoint(1.0f, 0.0f)};
        this.pointArray = tempArray;
    }

    public void createChain() {
        SampleIn sin = new SampleIn(this, this.fileName);
        NoteBufferReversed nb = new NoteBufferReversed(sin);
        ReSample reSample = new ReSample((AudioObject)nb, this.baseFreq);
        Volume vol = new Volume((AudioObject)reSample, 1.0f);
        Envelope env = new Envelope((AudioObject)vol, this.pointArray);
        SampleOut sout = new SampleOut(env, "jmusic.tmp");
    }
}

