/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Envelope;
import jm.audio.synth.Filter;
import jm.audio.synth.Multiply;
import jm.audio.synth.Oscillator;
import jm.audio.synth.Value;
import jm.audio.synth.Volume;

public class SawLPFInstE
extends Instrument {
    private int sampleRate;
    private int filterCutoff;
    private int channels;

    public SawLPFInstE(int sampleRate) {
        this(sampleRate, 1000, 1);
    }

    public SawLPFInstE(int sampleRate, int filterCutoff) {
        this(sampleRate, filterCutoff, 1);
    }

    public SawLPFInstE(int sampleRate, int filterCutoff, int channels) {
        this.sampleRate = sampleRate;
        this.filterCutoff = filterCutoff;
        this.channels = channels;
    }

    public void createChain() {
        Envelope filtEnv = new Envelope((Instrument)this, this.sampleRate, this.channels, new double[]{0.0, 0.0, 0.5, 1.0, 1.0, 0.0});
        Value scalefactor = new Value((Instrument)this, this.sampleRate, this.channels, 2000.0f);
        Multiply mult = new Multiply(new AudioObject[]{filtEnv, scalefactor});
        Oscillator wave = new Oscillator(this, 4, this.sampleRate, this.channels);
        Filter filt = new Filter(new AudioObject[]{wave, mult}, (double)this.filterCutoff, 0);
        Envelope env = new Envelope((AudioObject)filt, new double[]{0.0, 0.0, 0.05, 1.0, 0.2, 0.4, 0.8, 0.3, 1.0, 0.0});
        Volume vol = new Volume(env);
        SampleOut sout = new SampleOut(vol);
    }
}

