/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Add;
import jm.audio.synth.Envelope;
import jm.audio.synth.Filter;
import jm.audio.synth.Multiply;
import jm.audio.synth.Oscillator;
import jm.audio.synth.Value;
import jm.audio.synth.Volume;

public final class SawLPFInstG
extends Instrument {
    private int sampleRate;
    private int filterCutoff;
    private int channels;

    public SawLPFInstG(int sampleRate) {
        this(sampleRate, 1000, 1);
    }

    public SawLPFInstG(int sampleRate, int filterCutoff) {
        this(sampleRate, filterCutoff, 1);
    }

    public SawLPFInstG(int sampleRate, int filterCutoff, int channels) {
        this.sampleRate = sampleRate;
        this.filterCutoff = filterCutoff;
        this.channels = channels;
    }

    public void createChain() {
        Value freq = new Value((Instrument)this, this.sampleRate, this.channels, 6.0f);
        Oscillator LFO = new Oscillator(freq, 0, 1);
        LFO.setAmp(3.0f);
        Envelope LFOenv = new Envelope((AudioObject)LFO, new double[]{0.0, 0.0, 0.2, 0.4, 0.4, 1.0, 0.8, 1.0, 1.0, 0.0});
        Value offsetFrequency = new Value((Instrument)this, this.sampleRate, this.channels, 1);
        AudioObject[] grp1 = new AudioObject[]{LFOenv, offsetFrequency};
        Add add = new Add(grp1);
        Envelope filtEnv = new Envelope((Instrument)this, this.sampleRate, this.channels, new double[]{0.0, 0.0, 0.5, 1.0, 1.0, 0.0});
        Value scalefactor = new Value((Instrument)this, this.sampleRate, this.channels, 2000.0f);
        Multiply mult = new Multiply(new AudioObject[]{filtEnv, scalefactor});
        Oscillator wave = new Oscillator(add, 4, 1);
        Filter filt = new Filter(new AudioObject[]{wave, mult}, (double)this.filterCutoff, 0);
        Envelope env = new Envelope((AudioObject)filt, new double[]{0.0, 0.0, 0.05, 1.0, 0.2, 0.4, 0.8, 0.3, 1.0, 0.0});
        Volume vol = new Volume(env);
        SampleOut sout = new SampleOut(vol);
    }
}

