/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Envelope;
import jm.audio.synth.Filter;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class Sawtooth_LPF_Env_Inst
extends Instrument {
    private int sampleRate;
    private int filterCutoff;
    private int channels;
    private double[] envValues;

    public Sawtooth_LPF_Env_Inst(int sampleRate) {
        this(sampleRate, 1000);
    }

    public Sawtooth_LPF_Env_Inst(int sampleRate, int filterCutoff) {
        this.sampleRate = sampleRate;
        this.filterCutoff = filterCutoff;
        this.channels = 1;
        this.envValues = new double[]{0.0, 0.0, 0.05, 1.0, 0.2, 0.4, 0.8, 0.3, 1.0, 0.0};
    }

    public Sawtooth_LPF_Env_Inst(int sampleRate, int filterCutoff, int chan) {
        this.sampleRate = sampleRate;
        this.filterCutoff = filterCutoff;
        this.channels = chan;
        this.envValues = new double[]{0.0, 0.0, 0.05, 1.0, 0.2, 0.4, 0.8, 0.3, 1.0, 0.0};
    }

    public Sawtooth_LPF_Env_Inst(int sampleRate, int filterCutoff, int chan, double[] env) {
        this.sampleRate = sampleRate;
        this.filterCutoff = filterCutoff;
        this.channels = chan;
        this.envValues = env;
    }

    public void createChain() {
        Oscillator wt = new Oscillator(this, 4, this.sampleRate, this.channels);
        Filter filt = new Filter(wt, (double)this.filterCutoff, 0);
        Envelope env = new Envelope((AudioObject)filt, this.envValues);
        Volume vol = new Volume(env);
        StereoPan pan = new StereoPan(vol);
        SampleOut sout = new SampleOut(pan);
    }
}

