/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleIn;
import jm.audio.io.SampleOut;
import jm.audio.synth.Envelope;
import jm.audio.synth.ReSample;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class SimpleSampleInst
extends Instrument {
    private String fileName;
    private int numOfChannels;
    private double baseFreq;
    private boolean wholeFile;
    private double[] points;
    private SampleOut sout;

    public SimpleSampleInst(String fileName) {
        this(fileName, 440.0);
    }

    public SimpleSampleInst(String fileName, double baseFreq) {
        this(fileName, baseFreq, false);
    }

    public SimpleSampleInst(String fileName, double baseFreq, double[] points) {
        this(fileName, baseFreq, false, points);
    }

    public SimpleSampleInst(String fileName, double baseFreq, boolean wholeFile) {
        this(fileName, baseFreq, wholeFile, new double[]{0.0, 0.0, 0.01, 1.0, 0.99, 1.0, 1.0, 0.0});
    }

    public SimpleSampleInst(String fileName, double baseFreq, boolean wholeFile, double[] points) {
        this.fileName = fileName;
        this.baseFreq = baseFreq;
        this.wholeFile = wholeFile;
        this.points = points;
    }

    public void createChain() {
        SampleIn sin = new SampleIn(this, this.fileName);
        ReSample reSample = new ReSample((AudioObject)sin, this.baseFreq);
        Volume vol = new Volume(reSample);
        StereoPan span = new StereoPan(vol);
        if (this.wholeFile) {
            sin.setWholeFile(this.wholeFile);
            if (this.output == 0) {
                this.sout = new SampleOut(span);
            }
        } else {
            Envelope env = new Envelope((AudioObject)span, this.points);
            if (this.output == 0) {
                this.sout = new SampleOut(env);
            }
        }
    }
}

