/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.EnvPoint;
import jm.audio.synth.Envelope;
import jm.audio.synth.Filter;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class TriangleInst
extends Instrument {
    private EnvPoint[] pointArray = new EnvPoint[10];
    private int sampleRate;
    private int channels;
    private SampleOut sout;

    public TriangleInst(int sampleRate) {
        this(sampleRate, 2);
    }

    public TriangleInst(int sampleRate, int channels) {
        this.sampleRate = sampleRate;
        this.channels = channels;
        EnvPoint[] tempArray = new EnvPoint[]{new EnvPoint(0.0f, 0.0f), new EnvPoint(0.02f, 1.0f), new EnvPoint(0.15f, 0.6f), new EnvPoint(0.9f, 0.3f), new EnvPoint(1.0f, 0.0f)};
        this.pointArray = tempArray;
    }

    public void createChain() {
        Oscillator wt = new Oscillator(this, 2, this.sampleRate, this.channels);
        Envelope env = new Envelope((AudioObject)wt, this.pointArray);
        Volume vol = new Volume(env);
        Filter filt = new Filter(vol, (double)((float)((double)this.sampleRate / 2.1)), 0);
        StereoPan span = new StereoPan(filt);
        if (this.output == 0) {
            this.sout = new SampleOut(span);
        }
    }
}

