/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Add;
import jm.audio.synth.EnvPoint;
import jm.audio.synth.Envelope;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class VibesInst
extends Instrument {
    private static int count = 0;
    private float[] frequencies;
    private float[] volumes;
    private EnvPoint[][] points;
    private float pan;
    private int sampleRate;
    private Oscillator[] wt;
    private Envelope[] env;
    private Volume[] vol;
    private Add add;
    private StereoPan[] span;
    private boolean header = true;
    private SampleOut sout;

    public VibesInst(int sampleRate) {
        this.sampleRate = sampleRate;
        int overtones = 3;
        EnvPoint[] pointArray = new EnvPoint[]{new EnvPoint(0.0f, 0.0f), new EnvPoint(0.002f, 1.0f), new EnvPoint(0.3f, 0.3f), new EnvPoint(0.9f, 0.1f), new EnvPoint(1.0f, 0.0f)};
        EnvPoint[] pointArray2 = new EnvPoint[]{new EnvPoint(0.0f, 0.0f), new EnvPoint(0.02f, 1.0f), new EnvPoint(0.2f, 0.2f), new EnvPoint(0.9f, 0.0f)};
        EnvPoint[] pointArray3 = new EnvPoint[]{new EnvPoint(0.0f, 0.0f), new EnvPoint(0.02f, 1.0f), new EnvPoint(0.4f, 0.3f), new EnvPoint(0.8f, 0.0f)};
        this.points = new EnvPoint[overtones][4];
        this.frequencies = new float[overtones];
        this.volumes = new float[overtones];
        this.points[0] = pointArray;
        this.points[1] = pointArray2;
        this.points[2] = pointArray3;
        this.frequencies[0] = 1.0f;
        this.frequencies[1] = 2.7f;
        this.frequencies[2] = 6.75f;
        this.volumes[0] = 1.0f;
        this.volumes[1] = 0.77f;
        this.volumes[2] = 0.7f;
    }

    public VibesInst(int sampleRate, float[] frequencies, float[] volumes, EnvPoint[][] points) {
        this.frequencies = frequencies;
        this.volumes = volumes;
        this.points = points;
        this.sampleRate = sampleRate;
    }

    public void createChain() {
        this.env = new Envelope[this.frequencies.length];
        this.vol = new Volume[this.frequencies.length];
        this.span = new StereoPan[this.frequencies.length];
        this.wt = new Oscillator[this.frequencies.length];
        for (int i = 0; i < this.frequencies.length; ++i) {
            this.wt[i] = new Oscillator(this, 0, this.sampleRate, 2);
            this.wt[i].setFrqRatio(this.frequencies[i]);
            this.env[i] = new Envelope((AudioObject)this.wt[i], this.points[i]);
            this.vol[i] = new Volume((AudioObject)this.env[i], this.volumes[i]);
            this.span[i] = new StereoPan((AudioObject)this.vol[i], this.pan);
        }
        this.add = new Add(this.span);
        this.sout = new SampleOut(this.add);
    }
}

