/*
 * Decompiled with CFR 0.152.
 */
package jm.audio;

import jm.JMC;
import jm.audio.AOException;
import jm.audio.Instrument;
import jm.music.data.Note;

public abstract class AudioObject
implements JMC {
    protected AudioObject[] previous;
    protected AudioObject[] next;
    protected String name;
    protected int sampleRate;
    protected int channels;
    protected int inputs = 0;
    protected Note currentNote = null;
    protected double currentNoteStartTime;
    protected int numOfSamples = 0;
    protected Instrument inst = null;
    protected boolean finished = true;
    private int returned;

    protected AudioObject(AudioObject previous, String name) {
        AudioObject[] tmp = new AudioObject[]{previous};
        this.name = name;
        this.previous = tmp;
        this.previous[0].setNext(this);
        this.inputs = 1;
    }

    protected AudioObject(AudioObject[] previous, String name) {
        this.name = name;
        this.previous = previous;
        for (int i = 0; i < previous.length; ++i) {
            previous[i].setNext(this);
        }
        this.inputs = previous.length;
    }

    protected AudioObject(Instrument inst, int sampleRate, String name) {
        this.inst = inst;
        this.name = name;
        this.sampleRate = sampleRate;
        this.inst.addPrimaryAO(this);
    }

    public abstract int work(float[] var1) throws AOException;

    private void setNext(AudioObject next) {
        if (this.next == null) {
            this.next = new AudioObject[1];
            this.next[0] = next;
        } else {
            AudioObject[] tmp = new AudioObject[this.next.length + 1];
            for (int i = 0; i < this.next.length; ++i) {
                tmp[i] = this.next[i];
            }
            tmp[this.next.length] = next;
            this.next = tmp;
        }
    }

    public int nextWork(float[] buffer) throws AOException {
        this.returned = 0;
        this.returned = this.work(buffer);
        this.inst.setFinished(this.finished);
        return this.returned;
    }

    protected void buildNext(Note note, double startTime, int numOfSamples) {
        if (this.next != null) {
            for (int i = 0; i < this.next.length; ++i) {
                this.next[i].numOfSamples = numOfSamples;
                this.next[i].inst = this.inst;
                this.next[i].channels = this.channels;
                this.next[i].sampleRate = this.sampleRate;
                this.next[i].newNote(note, startTime, numOfSamples);
            }
        } else {
            try {
                this.inst.setFinalAO(this);
            }
            catch (AOException aoe) {
                System.out.println(aoe);
                System.exit(1);
            }
        }
    }

    protected void build() {
    }

    public void newNote(Note note, double startTime, int numOfSamples) {
        this.currentNote = note;
        this.currentNoteStartTime = startTime;
        this.numOfSamples = numOfSamples;
        this.build();
        this.buildNext(this.currentNote, this.currentNoteStartTime, this.numOfSamples);
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }
}

