/*
 * Decompiled with CFR 0.152.
 */
package jm.audio;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import jm.audio.AudioChainListener;
import jm.audio.Instrument;
import jm.music.rt.RTLine;

public class RTMixer
implements AudioChainListener {
    public long currentTime = 0L;
    protected int sampleRate;
    protected int channels;
    protected double controlRate;
    private int totLines = 0;
    private int count = 0;
    private float[] sampleArray;
    private ByteArrayOutputStream bos;
    private DataOutputStream dos;
    private SourceDataLine dline;
    private double scorePosition = 0.0;
    private RTLine[] rtlines;
    private int bufferSize;

    public RTMixer(RTLine[] rtlines) {
        this(rtlines, 0.1);
    }

    public RTMixer(RTLine[] rtlines, double controlRate) {
        this.rtlines = rtlines;
        this.sampleRate = rtlines[0].getSampleRate();
        this.channels = rtlines[0].getChannels();
        this.controlRate = controlRate;
        this.bufferSize = (int)((double)(this.sampleRate * this.channels) * this.controlRate);
        while (this.bufferSize % 4 != 0) {
            this.controlRate += 0.001;
            this.bufferSize = (int)((double)(this.sampleRate * this.channels) * this.controlRate);
        }
        for (int i = 0; i < rtlines.length; ++i) {
            this.totLines += this.rtlines[i].getNumLines();
            this.rtlines[i].setBufferSize(this.bufferSize);
            if (rtlines[i].getSampleRate() != this.sampleRate) {
                System.err.println("jMusic RTMixer error: All instruments must have the same sample rate.");
                System.exit(0);
            }
            if (rtlines[i].getChannels() == this.channels) continue;
            System.err.println("jMusic RTMixer error: All instruments must have the same number of channels.");
            System.exit(0);
        }
        this.initJMFSound(this.bufferSize);
        this.bos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.bos);
    }

    public void addLines(RTLine[] lines) {
        int i;
        RTLine[] temp = new RTLine[this.totLines + lines.length];
        for (i = 0; i < this.rtlines.length; ++i) {
            temp[i] = this.rtlines[i];
        }
        for (i = this.rtlines.length; i < temp.length; ++i) {
            if (this.rtlines[i].getSampleRate() != this.sampleRate) {
                System.err.println("jMusic RTMixer error: All instruments must have the same sample rate.");
                System.exit(0);
            }
            if (this.rtlines[i].getChannels() != this.channels) {
                System.err.println("jMusic RTMixer error: All instruments must have the same number of channels.");
                System.exit(0);
            }
            temp[i] = lines[i - this.rtlines.length];
            this.totLines += this.rtlines[i].getNumLines();
            temp[i].setBufferSize(this.bufferSize);
        }
        this.rtlines = temp;
    }

    public synchronized void controlChange(float[] buffer, int returned, boolean finished) {
        for (int i = 0; i < returned; ++i) {
            int n = i;
            this.sampleArray[n] = this.sampleArray[n] + buffer[i];
        }
        if (++this.count == this.totLines) {
            this.scorePosition += this.controlRate;
            for (int j = 0; j < this.rtlines.length; ++j) {
                Instrument[] inst = this.rtlines[j].getInstrument();
                for (int i = 0; i < inst.length; ++i) {
                    inst[i].release();
                }
            }
            this.count = 0;
            this.writeOutAudio(this.sampleArray.length);
        }
    }

    public void begin() {
        this.sampleArray = new float[this.bufferSize];
        for (int i = 0; i < this.rtlines.length; ++i) {
            this.rtlines[i].start(this);
        }
    }

    public void pause() {
        for (int i = 0; i < this.rtlines.length; ++i) {
            this.rtlines[i].pause();
        }
    }

    public void unPause() {
        for (int i = 0; i < this.rtlines.length; ++i) {
            this.rtlines[i].unPause();
        }
    }

    public void stop() {
        for (int i = 0; i < this.rtlines.length; ++i) {
            this.rtlines[i].stop();
        }
    }

    public void actionLines(Object obj, int actionNumber) {
        for (int i = 0; i < this.rtlines.length; ++i) {
            this.rtlines[i].externalAction(obj, actionNumber);
        }
    }

    private void writeOutAudio(int length) {
        this.bos.reset();
        for (int i = 0; i < length; ++i) {
            if (this.totLines > 1) {
                this.sampleArray[i] = this.sampleArray[i] / ((float)this.totLines * 0.75f);
            }
            try {
                this.dos.writeShort((short)(this.sampleArray[i] * 32767.0f));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            this.sampleArray[i] = 0.0f;
        }
        int returned = this.dline.write(this.bos.toByteArray(), 0, this.bos.size());
        this.currentTime += (long)length;
    }

    private void initJMFSound(int bufferSize) {
        AudioFormat af = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.sampleRate, 16, this.channels, this.channels * 2, this.sampleRate, true);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, af);
        if (!AudioSystem.isLineSupported(info)) {
            System.out.println(info);
            System.err.println("jMusic RTMixer error: JMF Line not supported. Real time audio must be 16 bit stereo ... exiting .. sorry :(");
            System.exit(1);
        }
        try {
            this.dline = (SourceDataLine)AudioSystem.getLine(info);
            this.dline.open(af, bufferSize * 8);
            this.dline.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finalize() {
        System.out.println("RTMixer finalizing...");
        try {
            this.dos.close();
            this.bos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dline.stop();
        this.dline.close();
    }
}

