/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import jm.JMC;
import jm.audio.AOException;
import jm.audio.AudioObject;

public final class PrintOut
extends AudioObject
implements JMC {
    private int width;

    public PrintOut(AudioObject ao) {
        this(ao, 80);
    }

    public PrintOut(AudioObject ao, int width) {
        super(ao, "[PrintOut]");
        this.width = width;
        try {
            RandomAccessFile f = new RandomAccessFile("jmusic.tmp", "rw");
            try {
                f.close();
            }
            catch (IOException e) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void finalize() {
    }

    public int work(float[] buffer) throws AOException {
        int returned = this.previous[0].nextWork(buffer);
        for (int i = 0; i < returned; ++i) {
            float sample = buffer[i];
            String dot = "";
            if (i % ((int)((double)this.sampleRate / 8000.0) + 1) != 0) continue;
            int counter = 0;
            for (int j = 0; j < (int)(((double)sample + 1.0) * ((double)this.width * 0.5 - 4.0)); ++j) {
                dot = dot + " ";
                ++counter;
            }
            dot = dot + "o";
            for (int k = counter; k < this.width - 4; ++k) {
                dot = dot + " ";
            }
            dot = dot + (double)((int)(sample *= 1000.0f)) / 1000.0;
            System.out.println(dot);
        }
        return returned;
    }
}

