/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.JMC;
import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.synth.EnvPoint;

public class ADSR
extends AudioObject
implements JMC {
    int maxAttackCount;
    int maxDecayCount;
    private EnvPoint[] graphPoints;
    private float[] graphShape;
    private boolean primary;
    private int attack;
    private int decay;
    private int release;
    private double sustain;
    private int totalSamples;
    private int sampleCounter = 0;
    private int position = 0;
    private double attackSamps;
    private double decaySamps;
    private double releaseSamps;
    private double prevRV = 0.0;

    public ADSR(Instrument inst, int sampleRate, int channels, int attack, int decay, double sustain, int release) {
        super(inst, sampleRate, "[ADSR]");
        this.channels = channels;
        this.attack = attack;
        this.decay = decay;
        this.sustain = sustain;
        this.release = release;
        this.primary = true;
        this.finished = false;
        this.calcSamps();
    }

    public ADSR(AudioObject ao, int attack, int decay, double sustain, int release) {
        super(ao, "[ADSR]");
        this.attack = attack;
        this.decay = decay;
        this.sustain = sustain;
        this.release = release;
        this.primary = false;
        this.finished = false;
    }

    public int work(float[] buffer) throws AOException {
        if (this.sampleCounter > this.totalSamples) {
            this.finished = true;
        }
        if (this.primary) {
            int returned = buffer.length;
            for (int i = 0; i < returned; i += this.channels) {
                for (int j = 0; j < this.channels; ++j) {
                    try {
                        buffer[i + j] = this.graphShape[this.position];
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException aob) {
                        buffer[i + j] = 0.0f;
                    }
                }
                ++this.position;
            }
            this.sampleCounter += buffer.length;
            return returned;
        }
        int returned = this.previous[0].nextWork(buffer);
        for (int i = 0; i < buffer.length; i += this.channels) {
            for (int j = 0; j < this.channels; ++j) {
                try {
                    if (this.sampleCounter < this.maxAttackCount) {
                        buffer[i + j] = buffer[i + j] * (float)((double)this.sampleCounter * 1.0 / (double)this.maxAttackCount);
                        continue;
                    }
                    if (this.sampleCounter < this.maxDecayCount + this.maxAttackCount) {
                        buffer[i + j] = buffer[i + j] * (float)(1.0 - (double)(this.sampleCounter - this.maxAttackCount) * (1.0 - this.sustain) / (double)this.maxDecayCount);
                        continue;
                    }
                    if (this.sampleCounter < this.numOfSamples) {
                        buffer[i + j] = buffer[i + j] * (float)this.sustain;
                        continue;
                    }
                    if (this.sampleCounter < this.totalSamples) {
                        buffer[i + j] = buffer[i + j] * (float)(this.sustain - (double)(this.sampleCounter - this.numOfSamples) * this.sustain / this.releaseSamps);
                        continue;
                    }
                    buffer[i + j] = 0.0f;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aob) {
                    buffer[i + j] = 0.0f;
                }
            }
            ++this.sampleCounter;
            ++this.position;
        }
        return returned;
    }

    private void calcSamps() {
        this.attackSamps = this.getSamps(this.attack);
        this.decaySamps = this.getSamps(this.decay);
        this.releaseSamps = this.getSamps(this.release);
    }

    private double getSamps(int milli) {
        return (double)milli / 1000.0 * (double)this.sampleRate;
    }

    public void build() {
        int i;
        this.sampleCounter = 0;
        this.position = 0;
        if (this.numOfSamples == 0) {
            return;
        }
        if (this.currentNote.getRhythmValue() == this.prevRV) {
            return;
        }
        this.calcSamps();
        this.totalSamples = this.numOfSamples + (int)this.releaseSamps;
        this.graphShape = new float[this.totalSamples];
        this.maxAttackCount = Math.min((int)this.attackSamps, this.numOfSamples);
        double inc = 1.0 / (double)this.maxAttackCount;
        for (i = 0; i < this.maxAttackCount; ++i) {
            this.graphShape[i] = (float)(inc * (double)i);
        }
        this.maxDecayCount = this.maxAttackCount;
        if (this.sustain < 1.0) {
            this.maxDecayCount = Math.min((int)this.attackSamps + (int)this.decaySamps, this.numOfSamples);
            double diff = (1.0 - this.sustain) / (double)(this.maxDecayCount - this.maxAttackCount);
            for (int i2 = this.maxAttackCount; i2 < this.maxDecayCount; ++i2) {
                this.graphShape[i2] = (float)(1.0 - diff * (double)(i2 - this.maxAttackCount));
            }
        }
        for (i = this.maxDecayCount; i < this.numOfSamples; ++i) {
            this.graphShape[i] = (float)this.sustain;
        }
        double startVal = this.graphShape[this.numOfSamples - 1];
        double inc2 = startVal / this.releaseSamps;
        for (int i3 = this.numOfSamples; i3 < this.totalSamples; ++i3) {
            this.graphShape[i3] = (float)(startVal - inc2 * (double)(i3 - this.numOfSamples));
        }
        this.finished = false;
    }
}

