/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class AllPass
extends AudioObject {
    private float decay;
    private int delay;
    private float[] delayLine;
    private int delayIndex;

    public AllPass(AudioObject ao, int delay) {
        this(ao, delay, 0.5);
    }

    public AllPass(AudioObject ao, int delay, double decay) {
        super(ao, "[AllPass]");
        this.decay = (float)decay;
        this.delay = delay;
    }

    public int work(float[] buffer) throws AOException {
        int i;
        int returned = this.previous[0].nextWork(buffer);
        for (i = 0; i < returned; ++i) {
            int n = i;
            buffer[n] = buffer[n] + this.delayLine[this.delayIndex] * this.decay;
            float a = buffer[i] * -this.decay;
            float b = this.delayLine[this.delayIndex];
            this.delayLine[this.delayIndex] = buffer[i];
            buffer[i] = a + b;
            if (this.delayIndex < this.delayLine.length) continue;
            this.delayIndex = 0;
        }
        return i;
    }

    public void build() {
        int sampleDelay = (int)((float)this.delay / 1000.0f * (float)this.sampleRate);
        this.delayLine = new float[sampleDelay * this.channels];
        this.delayIndex = 0;
    }
}

