/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Comb
extends AudioObject {
    private float decay;
    private int delay;
    private float[] delayLine;
    private int delayIndex;

    public Comb(AudioObject ao, int delay) {
        this(ao, delay, 0.5);
    }

    public Comb(AudioObject ao, int delay, double decay) {
        super(ao, "[Comb]");
        this.decay = (float)decay;
        this.delay = delay;
    }

    public int work(float[] buffer) throws AOException {
        int i;
        int returned = this.previous[0].nextWork(buffer);
        for (i = 0; i < returned; ++i) {
            float t = this.delayLine[this.delayIndex];
            int n = i;
            buffer[n] = buffer[n] + t * this.decay;
            this.delayLine[this.delayIndex++] = buffer[i];
            if (this.delayIndex < this.delayLine.length) continue;
            this.delayIndex = 0;
        }
        return i;
    }

    public void build() {
        int sampleDelay = (int)((float)this.delay / 1000.0f * (float)this.sampleRate);
        this.delayLine = new float[sampleDelay * this.channels];
        this.delayIndex = 0;
    }
}

