/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Grain2
extends AudioObject {
    private int grainSampSize = 1000;
    private int spaceSamp = 1000;
    private int grainCount = 0;
    private int spaceCount = 0;
    private int offset = 0;
    private boolean grainOn = true;

    public Grain2(AudioObject ao, int grainSampSize, int spaceSamp, boolean grainOn, int chan, int offset) {
        super(ao, "[Grain]");
        this.grainSampSize = grainSampSize * chan;
        this.spaceSamp = spaceSamp * chan;
        this.grainOn = grainOn;
        this.offset = offset;
    }

    public int work(float[] buffer) throws AOException {
        int counter;
        int returned = this.previous[0].nextWork(buffer);
        int tempoffset = this.offset;
        if (this.offset > 0) {
            for (counter = 0; counter < this.offset; ++counter) {
                buffer[counter] = 0.0f;
            }
            this.offset = 0;
        }
        for (counter = tempoffset; counter < returned; ++counter) {
            if (this.grainOn) {
                buffer[counter] = buffer[counter] * (float)Math.sin(Math.PI * (double)this.grainCount / (double)this.grainSampSize);
            }
            if (this.grainOn && this.grainCount < this.grainSampSize) {
                ++this.grainCount;
            } else if (this.grainOn) {
                this.grainOn = false;
                this.grainCount = 0;
            }
            if (!this.grainOn) {
                buffer[counter] = 0.0f;
            }
            if (!this.grainOn && this.spaceCount < this.spaceSamp) {
                ++this.spaceCount;
                continue;
            }
            if (this.grainOn) continue;
            this.grainOn = true;
            this.spaceCount = 0;
        }
        return returned;
    }

    public void setGrainDur(int gdur) {
        this.grainSampSize = gdur;
        System.out.println("Space4: " + this.grainSampSize);
    }

    public void setSpaceDur(int sdur) {
        this.spaceSamp = sdur;
        System.out.println("Space4: " + this.spaceSamp);
    }
}

