/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;

public class Oscillator
extends AudioObject {
    public static final int SINE_WAVE = 0;
    private int waveType = 0;
    public static final int COSINE_WAVE = 1;
    public static final int TRIANGLE_WAVE = 2;
    public static final int SQUARE_WAVE = 3;
    public static final int SAWTOOTH_WAVE = 4;
    public static final int SAWDOWN_WAVE = 5;
    public static final int SABERSAW_WAVE = 6;
    public static final int PULSE_WAVE = 7;
    public static final int AMPLITUDE = 0;
    public static final int FREQUENCY = 1;
    private float si;
    private float phase;
    private int choice;
    private float amp = 1.0f;
    private float frq = -1.0f;
    private float frqRatio = 1.0f;
    private double pulseWidth = 0.15;

    public Oscillator(AudioObject[] ao) throws AOException {
        super(ao, "[Oscillator]");
        if (ao.length > 2) {
            throw new AOException(this.name, 1);
        }
    }

    public Oscillator(AudioObject ao, int waveType, int choice) {
        super(ao, "[Oscillator]");
        this.waveType = waveType;
        this.choice = choice;
    }

    public Oscillator(AudioObject ao, int waveType, int choice, double val) {
        super(ao, "[Oscillator]");
        this.waveType = waveType;
        this.choice = choice;
        if (choice == 1) {
            this.frq = (float)val;
        } else {
            this.amp = (float)val;
        }
    }

    public Oscillator(Instrument inst) {
        this(inst, 0);
    }

    public Oscillator(Instrument inst, int waveType) {
        this(inst, waveType, 44100);
    }

    public Oscillator(Instrument inst, int waveType, int sampleRate) {
        this(inst, waveType, sampleRate, 1);
    }

    public Oscillator(Instrument inst, int waveType, int sampleRate, int channels) {
        super(inst, sampleRate, "[Oscillator]");
        this.waveType = waveType;
        this.channels = channels;
    }

    public Oscillator(Instrument inst, int waveType, int sampleRate, int channels, int fixedModChoice, double freqVal) {
        super(inst, sampleRate, "[Oscillator]");
        this.waveType = waveType;
        this.channels = channels;
        this.choice = fixedModChoice;
        if (this.choice == 1) {
            this.frq = (float)freqVal;
        } else {
            this.amp = (float)freqVal;
        }
    }

    public int work(float[] buffer) throws AOException {
        int buffneed = buffer.length / this.channels;
        int ret = 0;
        if (this.inputs == 2) {
            float[] freqbuf;
            float[] ampbuf = new float[buffneed];
            int returned = this.previous[0].nextWork(ampbuf);
            if (returned != this.previous[1].work(freqbuf = new float[returned])) {
                throw new AOException(this.name, 0);
            }
            int i = 0;
            while (ret < buffer.length) {
                this.setSI(freqbuf[i] * this.frqRatio);
                float sample = this.getWaveSample() * this.amp * ampbuf[i];
                for (int j = 0; j < this.channels; ++j) {
                    buffer[ret++] = sample;
                }
                ++i;
            }
        } else if (this.inputs == 1 && this.choice == 0) {
            float[] ampbuf = new float[buffneed];
            int returned = this.previous[0].nextWork(ampbuf);
            int i = 0;
            while (ret < buffer.length) {
                float sample = this.getWaveSample() * this.amp * ampbuf[i];
                for (int j = 0; j < this.channels; ++j) {
                    buffer[ret++] = sample;
                }
                ++i;
            }
        } else if (this.inputs == 1 && this.choice == 1) {
            float[] frqbuf = new float[buffneed];
            int returned = this.previous[0].work(frqbuf);
            for (int i = 0; i < buffneed; ++i) {
                this.setSI(frqbuf[i] * this.frqRatio);
                float sample = this.getWaveSample() * this.amp;
                for (int j = 0; j < this.channels; ++j) {
                    buffer[ret++] = sample;
                }
            }
        } else {
            while (ret < buffer.length) {
                if (this.choice == 1) {
                    this.setSI(this.frq * this.frqRatio);
                }
                float sample = this.getWaveSample() * this.amp;
                for (int j = 0; j < this.channels; ++j) {
                    try {
                        buffer[ret++] = sample;
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        --ret;
                    }
                }
            }
        }
        return ret;
    }

    public void build() {
        if (this.frq < 0.0f) {
            float notesFrq = (float)this.currentNote.getFrequency();
            this.setSI(notesFrq *= this.frqRatio);
        } else {
            this.frq *= this.frqRatio;
            this.setSI(this.frq);
        }
    }

    public void setChoice(int choiceVal) {
        this.choice = choiceVal;
    }

    public float getAmp() {
        return this.amp;
    }

    public void setAmp(float amp) {
        this.amp = amp;
        this.choice = 0;
    }

    public void setFrq(float frq) {
        this.frq = frq;
        this.choice = 1;
    }

    public void setFrqRatio(double frqRatio) {
        this.frqRatio = (float)frqRatio;
    }

    protected void setSI(double frequency) {
        this.si = (float)Math.PI * 2 / ((float)this.sampleRate / (float)frequency);
    }

    protected float getWaveSample() {
        switch (this.waveType) {
            case 0: {
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                float sample = (float)Math.sin(this.phase + (float)Math.PI * 2);
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return sample;
            }
            case 1: {
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                float sample = (float)Math.cos(this.phase + (float)Math.PI * 2);
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return sample;
            }
            case 2: {
                float position;
                float sample = 0.0f;
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                if ((position = 0.15915494f * this.phase) <= 0.25f) {
                    sample = (float)((double)position * 4.0);
                }
                if (position > 0.25f && position <= 0.75f) {
                    sample = (float)(4.0 * (0.5 - (double)position));
                }
                if (position > 0.75f) {
                    sample = (float)(((double)position - 1.0) * 4.0);
                }
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return sample;
            }
            case 3: {
                float position;
                float sample = 0.0f;
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                sample = (position = 0.15915494f * this.phase) < 0.5f ? 1.0f : -1.0f;
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return sample;
            }
            case 4: {
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                float position = 0.31830987f * this.phase;
                float sample = (float)((double)position - 1.0);
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return sample;
            }
            case 5: {
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                float position = 0.31830987f * this.phase;
                float sample = (float)(1.0 - (double)position);
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return sample;
            }
            case 6: {
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                float position = 0.15915494f * this.phase;
                float sample = (float)Math.exp(position) - 2.0f;
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return sample;
            }
            case 7: {
                float position;
                float sample = 0.0f;
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                sample = (position = 0.15915494f * this.phase) < (float)this.pulseWidth ? 1.0f : -1.0f;
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return sample;
            }
        }
        System.err.println("Incorrect oscillator type selected.");
        System.exit(1);
        return 0.0f;
    }

    public void setPulseWidth(double width) {
        if (width >= 0.0 && width <= 1.0) {
            this.pulseWidth = width;
        } else {
            System.err.println("Pulse wide must be between 0.0 and 1.0");
        }
    }

    public void setPhase(double phase) {
        this.phase = (float)phase;
    }
}

