/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Smooth
extends AudioObject {
    private float[] prevSampleValues;

    public Smooth(AudioObject ao) {
        super(ao, "[Smooth]");
    }

    public void build() {
        this.prevSampleValues = new float[this.channels];
        for (int i = 0; i < this.prevSampleValues.length; ++i) {
            this.prevSampleValues[i] = 0.0f;
        }
    }

    public int work(float[] buffer) throws AOException {
        int returned = this.previous[0].nextWork(buffer);
        for (int i = 0; i < returned; i += this.channels) {
            for (int j = 0; j < this.channels; ++j) {
                buffer[i + j] = buffer[i + j] * 0.5f + this.prevSampleValues[j] * 0.5f;
                this.prevSampleValues[j] = buffer[i + j];
            }
        }
        return returned;
    }
}

