/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.synth.MassObject;
import jm.audio.synth.SpringObject;

public class SpringPipe {
    int totalLength = 500;
    double width = 1.0;
    double pluckAmt = 1.0;
    private SpringObject[] springObjectArray;
    private MassObject[] massObjectArray;

    public SpringPipe(int nodeNumb, double springConstant, double friction, double jitter) {
        SpringObject[] tempS = new SpringObject[nodeNumb + 1];
        MassObject[] tempM = new MassObject[nodeNumb];
        int springLength = (int)((double)this.totalLength - (double)nodeNumb * this.width) / (nodeNumb + 1);
        for (int i = 0; i < nodeNumb; ++i) {
            tempS[i] = new SpringObject(springConstant);
            tempS[i].setRestingLength(springLength);
            tempM[i] = new MassObject(friction, 1.0 + (Math.random() * jitter - jitter / 2.0));
            tempM[i].setYPosition((double)springLength * ((double)i + 1.0) + this.width * (double)i);
        }
        tempS[nodeNumb] = new SpringObject();
        tempS[nodeNumb].setRestingLength(springLength);
        tempM[0].setYPosition(tempM[0].getYPosition() - tempM[0].getYPosition() * this.pluckAmt);
        this.springObjectArray = tempS;
        this.massObjectArray = tempM;
    }

    private void updateSpringMassNetwork() {
        int i;
        double[] forceArray = new double[this.springObjectArray.length];
        forceArray[0] = this.springObjectArray[0].getCurrentForce(0.0, this.massObjectArray[0].getYPosition());
        for (i = 1; i < this.massObjectArray.length; ++i) {
            forceArray[i] = this.springObjectArray[i].getCurrentForce(this.massObjectArray[i - 1].getYPosition() + this.width, this.massObjectArray[i].getYPosition());
        }
        forceArray[forceArray.length - 1] = this.springObjectArray[forceArray.length - 1].getCurrentForce(this.massObjectArray[this.massObjectArray.length - 1].getYPosition() + this.width, this.totalLength);
        for (i = 0; i < this.massObjectArray.length; ++i) {
            this.massObjectArray[i].setYPosition(this.massObjectArray[i].getYPosition() + this.massObjectArray[i].getDisplacement(forceArray[i] - forceArray[i + 1]));
        }
    }

    public double getNextNodePosition(int nodeIndex) {
        this.updateSpringMassNetwork();
        return this.massObjectArray[nodeIndex].getYPosition();
    }
}

