/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;

public class WaveTable
extends AudioObject {
    public static final int AMPLITUDE = 0;
    public static final int FREQUENCY = 1;
    public static final int MONO = 1;
    public static final int STEREO = 2;
    private float[] waveTable;
    private float si;
    private float phase;
    private int aoDestination;
    private float amp = 1.0f;
    private float frq = -1.0f;
    private float frqRatio = 1.0f;

    public WaveTable(AudioObject[] ao, float[] waveTable) throws AOException {
        super(ao, "[WaveTable]");
        if (ao.length > 2) {
            throw new AOException(this.name, 1);
        }
        this.waveTable = waveTable;
    }

    public WaveTable(AudioObject ao, float[] waveTable, int aoDestination) {
        super(ao, "[WaveTable]");
        this.waveTable = waveTable;
        this.aoDestination = aoDestination;
    }

    public WaveTable(Instrument inst, int sampleRate, float[] waveTable, int channels, int aoDestination, float val) {
        super(inst, sampleRate, "[WaveTable]");
        this.waveTable = waveTable;
        this.channels = channels;
        this.aoDestination = aoDestination;
        if (aoDestination == 1) {
            this.frq = val;
        } else {
            this.amp = val;
        }
    }

    public WaveTable(Instrument inst, int sampleRate, float[] waveTable, int channels) {
        super(inst, sampleRate, "[WaveTable]");
        this.waveTable = waveTable;
        this.channels = channels;
    }

    public int work(float[] buffer) throws AOException {
        int buffneed = buffer.length / this.channels;
        int ret = 0;
        if (this.inputs == 2) {
            float[] freqbuf;
            float[] ampbuf = new float[buffneed];
            int returned = this.previous[0].nextWork(ampbuf);
            if (returned != this.previous[1].work(freqbuf = new float[returned])) {
                throw new AOException(this.name, 0);
            }
            int i = 0;
            while (ret < buffer.length) {
                this.setSI((int)freqbuf[i]);
                if (this.phase < 0.0f) {
                    this.phase = (float)this.waveTable.length + this.phase;
                }
                float sample = this.waveTable[(int)this.phase] * (this.amp * ampbuf[i]);
                this.phase += this.si;
                if (this.phase >= (float)this.waveTable.length) {
                    this.phase -= (float)this.waveTable.length;
                }
                for (int j = 0; j < this.channels; ++j) {
                    buffer[ret++] = sample;
                }
                ++i;
            }
        } else if (this.inputs == 1 && this.aoDestination == 0) {
            float[] ampbuf = new float[buffneed];
            int returned = this.previous[0].nextWork(ampbuf);
            int i = 0;
            while (ret < buffer.length) {
                float sample = this.waveTable[(int)this.phase] * (this.amp * ampbuf[i]);
                this.phase += this.si;
                if (this.phase >= (float)this.waveTable.length) {
                    this.phase -= (float)this.waveTable.length;
                }
                for (int j = 0; j < this.channels; ++j) {
                    buffer[ret++] = sample;
                }
                ++i;
            }
        } else if (this.inputs == 1 && this.aoDestination == 1) {
            float[] frqbuf = new float[buffneed];
            int returned = this.previous[0].work(frqbuf);
            for (int i = 0; i < buffneed; ++i) {
                this.setSI((int)frqbuf[i]);
                if (this.phase < 0.0f) {
                    this.phase = (float)this.waveTable.length + this.phase;
                }
                float sample = this.waveTable[(int)this.phase] * this.amp;
                this.phase += this.si;
                if (this.phase >= (float)this.waveTable.length) {
                    this.phase -= (float)this.waveTable.length;
                }
                for (int j = 0; j < this.channels; ++j) {
                    buffer[ret++] = sample;
                }
            }
        } else {
            while (ret < buffer.length) {
                float sample = this.waveTable[(int)this.phase] * this.amp;
                this.phase += this.si;
                if (this.phase >= (float)this.waveTable.length) {
                    this.phase -= (float)this.waveTable.length;
                }
                for (int j = 0; j < this.channels; ++j) {
                    try {
                        buffer[ret++] = sample;
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        --ret;
                    }
                }
            }
        }
        return ret;
    }

    public void build() {
        float notesFrq = (float)this.currentNote.getFrequency() * this.frqRatio;
        if (this.frq < 0.0f) {
            this.setSI(notesFrq);
        } else {
            this.setSI(this.frq);
        }
    }

    public void setAmp(float amp) {
        this.amp = amp;
    }

    public void setFrq(float frq) {
        this.frq = frq;
    }

    public void setFrqRatio(float frqRatio) {
        this.frqRatio = frqRatio;
    }

    protected void setSI(float frequency) {
        this.si = frequency / (float)this.sampleRate * (float)this.waveTable.length;
    }
}

