/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Waveshaper
extends AudioObject {
    public static final int POLYNOMIAL = 0;
    public static final int CHEBYSHEV = 1;
    private int shapeType = 1;
    private int stages = 4;
    private double[] weights;

    public Waveshaper(AudioObject ao) {
        super(ao, "[Waveshaper]");
        this.shapeType = 1;
        this.stages = 4;
        double[] defaultWeights = new double[]{0.3, 0.8, 0.6, 0.4};
        this.weights = defaultWeights;
    }

    public Waveshaper(AudioObject ao, int shape, int depth) {
        super(ao, "[Waveshaper]");
        this.shapeType = shape;
        this.stages = depth;
        double[] defaultWeights = new double[]{0.3, 0.8, 0.6, 0.4};
        this.weights = defaultWeights;
    }

    public Waveshaper(AudioObject ao, int shape, int depth, double[] weights) {
        super(ao, "[Waveshaper]");
        this.shapeType = shape;
        this.stages = depth;
        this.weights = weights;
    }

    public int work(float[] buffer) throws AOException {
        int returned;
        block16: {
            block15: {
                returned = this.previous[0].nextWork(buffer);
                if (this.shapeType != 0) break block15;
                for (int i = 0; i < returned; ++i) {
                    float currentValue;
                    float result = currentValue = Math.abs(buffer[i]);
                    for (int s = 1; s < this.stages; ++s) {
                        float product = currentValue;
                        for (int j = 0; j < s; ++j) {
                            product *= currentValue;
                        }
                        result = (float)((double)result + (double)product * this.weights[s]);
                    }
                    if ((double)buffer[i] < 0.0) {
                        result *= -1.0f;
                    }
                    buffer[i] = result;
                }
                break block16;
            }
            if (this.shapeType != 1) break block16;
            for (int i = 0; i < returned; ++i) {
                float currentValue;
                float result = currentValue = Math.abs(buffer[i]);
                if (this.stages > 1) {
                    result = (float)((double)result + this.weights[0] * (double)(2.0f * currentValue * currentValue - 1.0f));
                }
                if (this.stages > 2) {
                    result = (float)((double)result + this.weights[1] * (double)(4.0f * (float)Math.pow(currentValue, 3.0) - 3.0f * currentValue));
                }
                if (this.stages > 3) {
                    result = (float)((double)result + this.weights[2] * (double)(8.0f * (float)Math.pow(currentValue, 4.0) - 8.0f * (float)Math.pow(currentValue, 2.0) + 1.0f));
                }
                if (this.stages > 4) {
                    result = (float)((double)result + this.weights[3] * (double)(16.0f * (float)Math.pow(currentValue, 5.0) - 20.0f * (float)Math.pow(currentValue, 3.0) + 5.0f * currentValue));
                }
                if (this.stages > 5) {
                    result = (float)((double)result + this.weights[4] * (double)(32.0f * (float)Math.pow(currentValue, 6.0) - 48.0f * (float)Math.pow(currentValue, 4.0) + 18.0f * (float)Math.pow(currentValue, 2.0) - 1.0f));
                }
                if (this.stages > 6) {
                    result = (float)((double)result + this.weights[5] * (double)(64.0f * (float)Math.pow(currentValue, 7.0) - 112.0f * (float)Math.pow(currentValue, 5.0) + 56.0f * (float)Math.pow(currentValue, 3.0) - 7.0f * currentValue));
                }
                if (this.stages > 7) {
                    result = (float)((double)result + this.weights[6] * (double)(128.0f * (float)Math.pow(currentValue, 8.0) - 256.0f * (float)Math.pow(currentValue, 6.0) + 160.0f * (float)Math.pow(currentValue, 4.0) - 32.0f * (float)Math.pow(currentValue, 2.0) + 1.0f));
                }
                if (this.stages > 8) {
                    result = (float)((double)result + this.weights[7] * (double)(256.0f * (float)Math.pow(currentValue, 9.0) - 576.0f * (float)Math.pow(currentValue, 7.0) + 432.0f * (float)Math.pow(currentValue, 5.0) - 120.0f * (float)Math.pow(currentValue, 3.0) + 9.0f * currentValue));
                }
                if (this.stages > 9) {
                    result = (float)((double)result + this.weights[8] * (double)(512.0f * (float)Math.pow(currentValue, 10.0) - 1280.0f * (float)Math.pow(currentValue, 8.0) + 1120.0f * (float)Math.pow(currentValue, 6.0) - 400.0f * (float)Math.pow(currentValue, 4.0) + 50.0f * (float)Math.pow(currentValue, 2.0) - 1.0f));
                }
                if ((double)buffer[i] < 0.0) {
                    result *= -1.0f;
                }
                buffer[i] = result;
            }
        }
        return returned;
    }
}

