/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.StringTokenizer;
import jm.music.data.Note;
import jm.music.data.Phrase;

public class CpnZoomScreen
extends Dialog
implements ActionListener,
WindowListener {
    private static TextField startMeasureEdit = new TextField(8);
    private static TextField measureCountEdit = new TextField(8);
    private static Label startMeasureLabel = new Label("Start at Measure");
    private static Label measureCountLabel = new Label("Number of Measures");
    private Phrase phrase;
    private Phrase beforeZoom;
    private Phrase afterZoom;
    private Button okButton = new Button("Update View:");
    private Button cancelButton = new Button("Cancel");

    public CpnZoomScreen(Frame parentFrame) {
        super(parentFrame, "Select the Measures to Show", true);
        this.setSize(500, 400);
        this.placeControls();
        this.addWindowListener(this);
        this.setVisible(false);
        this.pack();
    }

    public static void zoomOut(Phrase before, Phrase thePhrase, Phrase after) {
        int i;
        for (i = 0; i < thePhrase.size(); ++i) {
            before.addNote(thePhrase.getNote(i));
        }
        for (i = 0; i < after.size(); ++i) {
            before.addNote(after.getNote(i));
        }
        thePhrase.empty();
        for (i = 0; i < before.size(); ++i) {
            thePhrase.addNote(before.getNote(i));
        }
        before.empty();
        after.empty();
    }

    private static boolean intFieldError(TextField theField, double minValue, double maxValue) {
        StringTokenizer fieldTokenizer = new StringTokenizer(theField.getText());
        if (!fieldTokenizer.hasMoreElements()) {
            theField.setText("Error");
            return true;
        }
        String fieldString = fieldTokenizer.nextToken();
        try {
            int fieldValue = new Integer(fieldString);
            if ((double)fieldValue < minValue) {
                theField.setText("Error");
                return true;
            }
            if ((double)fieldValue > maxValue) {
                theField.setText("Error");
                return true;
            }
        }
        catch (Throwable e) {
            theField.setText("Error");
            return true;
        }
        if (fieldTokenizer.hasMoreElements()) {
            theField.setText("Error");
            return true;
        }
        return false;
    }

    private static int getIntegerValue(TextField theField) {
        StringTokenizer fieldTokenizer = new StringTokenizer(theField.getText());
        String fieldString = fieldTokenizer.nextToken();
        return new Integer(fieldString);
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.dispose();
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void zoomIn(Phrase before, Phrase thePhrase, Phrase after) {
        this.phrase = thePhrase;
        this.beforeZoom = before;
        this.afterZoom = after;
        this.beforeZoom.empty();
        this.afterZoom.empty();
        this.setLocation(20, 20);
        this.show();
    }

    private void placeControls() {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(layout);
        c.fill = 1;
        c.weightx = 0.5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        layout.setConstraints(startMeasureLabel, c);
        this.add(startMeasureLabel);
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 1;
        layout.setConstraints(startMeasureEdit, c);
        this.add(startMeasureEdit);
        c.gridx = 0;
        c.gridy = 1;
        c.gridheight = 1;
        layout.setConstraints(measureCountLabel, c);
        this.add(measureCountLabel);
        c.gridx = 1;
        c.gridy = 1;
        c.gridheight = 1;
        layout.setConstraints(measureCountEdit, c);
        this.add(measureCountEdit);
        c.gridx = 0;
        c.gridy = 3;
        c.gridheight = 1;
        layout.setConstraints(this.okButton, c);
        this.add(this.okButton);
        this.okButton.addActionListener(this);
        c.gridx = 1;
        c.gridy = 3;
        c.gridheight = 1;
        this.add(this.cancelButton);
        layout.setConstraints(this.cancelButton, c);
        this.cancelButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.startFieldError()) {
                startMeasureEdit.setText("Error");
            } else if (this.countFieldError()) {
                measureCountEdit.setText("Error");
            } else {
                this.zoom();
                this.dispose();
            }
        }
        if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    private double countMeasures(Phrase p) {
        double answer = 0.0;
        for (int i = 0; i < p.size(); ++i) {
            answer += p.getNote(i).getRhythmValue();
        }
        return answer / (double)p.getNumerator();
    }

    private boolean startFieldError() {
        return CpnZoomScreen.intFieldError(startMeasureEdit, 1.0, this.countMeasures(this.phrase) + 0.99);
    }

    private boolean countFieldError() {
        return CpnZoomScreen.intFieldError(measureCountEdit, 1.0, 99999.99);
    }

    private void moveMeasures(Phrase fromPhrase, Phrase toPhrase, double nMeasures) {
        double beatValue;
        for (double beatCount = nMeasures * (double)fromPhrase.getNumerator(); beatCount > 0.005 && fromPhrase.size() > 0; beatCount -= beatValue) {
            Note theNote = fromPhrase.getNote(0);
            beatValue = theNote.getRhythmValue();
            toPhrase.addNote(theNote);
            fromPhrase.removeNote(0);
        }
    }

    private void moveAll(Phrase fromPhrase, Phrase toPhrase) {
        while (fromPhrase.size() > 0) {
            Note theNote = fromPhrase.getNote(0);
            toPhrase.addNote(theNote);
            fromPhrase.removeNote(0);
        }
    }

    private void zoom() {
        int n = CpnZoomScreen.getIntegerValue(startMeasureEdit) - 1;
        int m = CpnZoomScreen.getIntegerValue(measureCountEdit);
        this.beforeZoom.empty();
        this.afterZoom.empty();
        this.moveMeasures(this.phrase, this.beforeZoom, n);
        this.moveAll(this.phrase, this.afterZoom);
        this.moveMeasures(this.afterZoom, this.phrase, (double)(n + m) - this.countMeasures(this.beforeZoom));
    }
}

