/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import jm.JMC;
import jm.gui.cpn.BassStave;
import jm.gui.cpn.CpnZoomScreen;
import jm.gui.cpn.GrandStave;
import jm.gui.cpn.JmMidiPlayer;
import jm.gui.cpn.LetterNotesEditor;
import jm.gui.cpn.ParmScreen;
import jm.gui.cpn.PhraseViewer;
import jm.gui.cpn.PianoStave;
import jm.gui.cpn.Stave;
import jm.gui.cpn.TrebleStave;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.util.Play;
import jm.util.Read;
import jm.util.Write;

public class Notate
extends Frame
implements ActionListener,
WindowListener,
JMC {
    public boolean timeToStop;
    private Score score;
    private Phrase[] phraseArray;
    private Stave[] staveArray;
    private int scrollHeight = 130;
    private int locationX = 0;
    private int locationY = 0;
    private Dialog keyDialog;
    private Dialog timeDialog;
    private MenuItem keySig;
    private MenuItem open;
    private MenuItem openJmXml;
    private MenuItem openjm;
    private MenuItem play;
    private MenuItem stop;
    private MenuItem delete;
    private MenuItem clear;
    private MenuItem newStave;
    private MenuItem close;
    private MenuItem timeSig;
    private MenuItem saveJmXml;
    private MenuItem saveJM;
    private MenuItem saveMidi;
    private MenuItem quit;
    private MenuItem trebleStave;
    private MenuItem bassStave;
    private MenuItem pianoStave;
    private MenuItem grandStave;
    private MenuItem automaticStave;
    private MenuItem appendMidiFile;
    private MenuItem insertMidiFile;
    private MenuItem setParameters;
    private MenuItem playAll;
    private MenuItem playMeasure;
    private MenuItem repeatAll;
    private MenuItem repeatMeasure;
    private MenuItem stopPlay;
    private MenuItem earTrain;
    private MenuItem addNotes;
    private MenuItem adjustTiming;
    private MenuItem viewDetails;
    private MenuItem viewTitle;
    private MenuItem viewZoom;
    private MenuItem barNumbers;
    private Panel scoreBG;
    private GridBagConstraints constraints;
    private GridBagLayout layout;
    private ScrollPane scroll;
    private String lastFileName = "*.mid";
    private String lastDirectory = "";
    private String fileNameFilter = "*.mid";
    private boolean zoomed;
    private Phrase beforeZoom = new Phrase();
    private Phrase afterZoom = new Phrase();
    private int height = 0;
    private int width = 700;

    public Notate() {
        this(new Phrase(), 0, 0);
        this.clearZoom();
    }

    public Notate(int locX, int locY) {
        this(new Phrase(), locX, locY);
        this.clearZoom();
    }

    public Notate(Phrase phr) {
        this(phr, 0, 0);
        this.clearZoom();
    }

    public Notate(Phrase phrase, int locX, int locY) {
        super("CPN: " + phrase.getTitle());
        this.clearZoom();
        this.score = new Score(new Part(phrase));
        this.locationX = locX;
        this.locationY = locY;
        this.score = new Score(new Part(phrase));
        this.init();
    }

    public Notate(Score score, int locX, int locY) {
        super("CPN: " + score.getTitle());
        this.clearZoom();
        this.score = score;
        this.locationX = locX;
        this.locationY = locY;
        this.init();
    }

    private static double getRhythmAdjustment(double beats, double beatIncrement) {
        double increments = beats / beatIncrement;
        double answer = 0.0;
        double n = Math.floor(increments);
        for (double tolerance = 1.0E-5; Math.floor(increments + tolerance) > n && tolerance > 1.0E-14; tolerance /= 2.0) {
            answer = tolerance;
        }
        return answer * beatIncrement;
    }

    private static void adjustTimeValues(Phrase phr) {
        double dt;
        double t;
        int i;
        for (i = 0; i < phr.size(); ++i) {
            t = phr.getNote(i).getRhythmValue();
            dt = Notate.getRhythmAdjustment(t, 0.00390625);
            phr.getNote(i).setRhythmValue(t + dt);
        }
        double st = 0.0;
        for (i = 0; i < phr.size(); ++i) {
            t = phr.getNote(i).getRhythmValue();
            dt = Notate.getRhythmAdjustment(st += t, 1.0);
            phr.getNote(i).setRhythmValue(t + dt);
            st += dt;
        }
    }

    private void clearZoom() {
        this.zoomed = false;
    }

    public void init() {
        this.addWindowListener(this);
        MenuBar menus = new MenuBar();
        Menu edit = new Menu("File", true);
        Menu features = new Menu("Tools", true);
        Menu player = new Menu("Play", true);
        Menu view = new Menu("View", true);
        this.newStave = new MenuItem("New", new MenuShortcut(78));
        this.newStave.addActionListener(this);
        edit.add(this.newStave);
        this.open = new MenuItem("Open MIDI file...", new MenuShortcut(79));
        this.open.addActionListener(this);
        edit.add(this.open);
        this.openJmXml = new MenuItem("Open jMusic XML file...");
        this.openJmXml.addActionListener(this);
        edit.add(this.openJmXml);
        this.openjm = new MenuItem("Open jm file..");
        this.openjm.addActionListener(this);
        edit.add(this.openjm);
        this.close = new MenuItem("Close", new MenuShortcut(87));
        this.close.addActionListener(this);
        edit.add(this.close);
        edit.add("-");
        this.delete = new MenuItem("Delete last note", new MenuShortcut(68));
        this.delete.addActionListener(this);
        edit.add(this.delete);
        this.clear = new MenuItem("Clear all notes", new MenuShortcut(67));
        this.clear.addActionListener(this);
        edit.add(this.clear);
        edit.add("-");
        this.keySig = new MenuItem("Key Signature", new MenuShortcut(75));
        this.keySig.addActionListener(this);
        edit.add(this.keySig);
        this.timeSig = new MenuItem("Time Signature", new MenuShortcut(84));
        this.timeSig.addActionListener(this);
        edit.add(this.timeSig);
        edit.add("-");
        this.saveMidi = new MenuItem("Save as a MIDI file...", new MenuShortcut(83));
        this.saveMidi.addActionListener(this);
        edit.add(this.saveMidi);
        this.saveJmXml = new MenuItem("Save as a jMusic XML file...", new MenuShortcut(83, true));
        this.saveJmXml.addActionListener(this);
        edit.add(this.saveJmXml);
        this.saveJM = new MenuItem("Save as a jm file...");
        this.saveJM.addActionListener(this);
        edit.add(this.saveJM);
        edit.add("-");
        this.setParameters = new MenuItem("Set Parameters...");
        this.setParameters.addActionListener(this);
        features.add(this.setParameters);
        this.addNotes = new MenuItem("Add Notes by Letter");
        this.addNotes.addActionListener(this);
        features.add(this.addNotes);
        this.adjustTiming = new MenuItem("Quantize Timing");
        this.adjustTiming.addActionListener(this);
        features.add(this.adjustTiming);
        this.playAll = new MenuItem("Play All", new MenuShortcut(80));
        this.playAll.addActionListener(this);
        player.add(this.playAll);
        this.repeatAll = new MenuItem("Repeat All");
        this.repeatAll.addActionListener(this);
        player.add(this.repeatAll);
        this.playMeasure = new MenuItem("Play Last Measure");
        this.playMeasure.addActionListener(this);
        player.add(this.playMeasure);
        this.repeatMeasure = new MenuItem("Repeat Last Measure");
        this.repeatMeasure.addActionListener(this);
        player.add(this.repeatMeasure);
        this.stopPlay = new MenuItem("Stop Playback", new MenuShortcut(80, true));
        this.stopPlay.addActionListener(this);
        player.add(this.stopPlay);
        Menu staveMenu = new Menu("Stave");
        edit.add(staveMenu);
        this.trebleStave = new MenuItem("Treble");
        this.trebleStave.addActionListener(this);
        staveMenu.add(this.trebleStave);
        this.bassStave = new MenuItem("Bass");
        this.bassStave.addActionListener(this);
        staveMenu.add(this.bassStave);
        this.pianoStave = new MenuItem("Piano");
        this.pianoStave.addActionListener(this);
        staveMenu.add(this.pianoStave);
        this.grandStave = new MenuItem("Grand");
        this.grandStave.addActionListener(this);
        staveMenu.add(this.grandStave);
        this.automaticStave = new MenuItem("Automatic");
        this.automaticStave.addActionListener(this);
        staveMenu.add(this.automaticStave);
        edit.add("-");
        this.quit = new MenuItem("Quit", new MenuShortcut(81));
        this.quit.addActionListener(this);
        edit.add(this.quit);
        this.viewDetails = new MenuItem("Note data as text");
        this.viewDetails.addActionListener(this);
        view.add(this.viewDetails);
        this.viewZoom = new MenuItem("View phrase section", new MenuShortcut(86));
        this.viewZoom.addActionListener(this);
        view.add(this.viewZoom);
        this.barNumbers = new MenuItem("Bar Numbers", new MenuShortcut(66));
        this.barNumbers.addActionListener(this);
        view.add(this.barNumbers);
        this.viewTitle = new MenuItem("Stave Title");
        this.viewTitle.addActionListener(this);
        view.add(this.viewTitle);
        menus.add(edit);
        menus.add(features);
        menus.add(player);
        menus.add(view);
        this.setMenuBar(menus);
        this.scroll = new ScrollPane(1);
        this.scroll.getHAdjustable().setUnitIncrement(10);
        this.scroll.getVAdjustable().setUnitIncrement(10);
        this.scoreBG = new Panel();
        this.layout = new GridBagLayout();
        this.scoreBG.setLayout(this.layout);
        this.constraints = new GridBagConstraints();
        this.setupConstraints();
        this.scroll.add(this.scoreBG);
        this.add(this.scroll);
        this.setupArrays();
        this.makeAppropriateStaves();
        this.pack();
        this.setLocation(this.locationX, this.locationY);
        this.show();
    }

    private void setupArrays() {
        this.phraseArray = new Phrase[this.score.size()];
        this.staveArray = new Stave[this.score.size()];
        for (int i = 0; i < this.staveArray.length; ++i) {
            this.phraseArray[i] = this.score.getPart(i).getPhrase(0);
            this.staveArray[i] = new PianoStave();
            this.staveArray[i].setKeySignature(this.score.getKeySignature());
            this.staveArray[i].setMetre(this.score.getNumerator());
            this.staveArray[i].setBarNumbers(true);
        }
    }

    private void setupConstraints() {
        this.constraints.weightx = 100.0;
        this.constraints.weighty = 0.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 1;
    }

    private void calcHeight() {
        this.height = 0;
        for (int i = 0; i < this.staveArray.length; ++i) {
            this.height += this.staveArray[i].getSize().height;
        }
    }

    private void makeAppropriateStaves() {
        Stave[] tempStaveArray = new Stave[this.staveArray.length];
        for (int i = 0; i < this.score.size(); ++i) {
            Phrase currentPhrase = this.score.getPart(i).getPhrase(0);
            tempStaveArray[i] = new PianoStave();
            if (currentPhrase.getHighestPitch() < 93 && currentPhrase.getLowestPitch() > 54) {
                tempStaveArray[i] = new TrebleStave();
                continue;
            }
            if (currentPhrase.getHighestPitch() < 65 && currentPhrase.getLowestPitch() > 35) {
                tempStaveArray[i] = new BassStave();
                continue;
            }
            if (currentPhrase.getHighestPitch() <= 93 && currentPhrase.getLowestPitch() >= 35) continue;
            tempStaveArray[i] = new GrandStave();
        }
        this.updateAllStaves(tempStaveArray);
    }

    private void makeTrebleStave() {
        Stave[] tempStaveArray = new Stave[this.score.size()];
        for (int i = 0; i < this.staveArray.length; ++i) {
            tempStaveArray[i] = new TrebleStave();
        }
        this.updateAllStaves(tempStaveArray);
    }

    private void updateAllStaves(Stave[] tempStaveArray) {
        int gridyVal = 0;
        int gridheightVal = 0;
        int totalHeight = 0;
        this.scoreBG.removeAll();
        for (int i = 0; i < this.staveArray.length; ++i) {
            tempStaveArray[i].setKeySignature(this.staveArray[i].getKeySignature());
            tempStaveArray[i].setMetre(this.staveArray[i].getMetre());
            tempStaveArray[i].setBarNumbers(this.staveArray[i].getBarNumbers());
            tempStaveArray[i].setPhrase(this.phraseArray[i]);
            this.staveArray[i] = tempStaveArray[i];
            tempStaveArray[i] = null;
            this.constraints.gridy = gridyVal;
            gridheightVal = this.staveArray[i].getClass().isInstance(new TrebleStave()) || this.staveArray[i].getClass().isInstance(new BassStave()) ? 1 : (this.staveArray[i].getClass().isInstance(new PianoStave()) ? 2 : 3);
            this.constraints.gridheight = gridheightVal;
            this.scoreBG.add((Component)this.staveArray[i], this.constraints);
            gridyVal += gridheightVal;
            totalHeight += this.staveArray[i].getPanelHeight();
        }
        this.scroll.setSize(new Dimension(this.width, totalHeight));
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        this.setSize(new Dimension(this.width, Math.min(d.height - 40, totalHeight + 40)));
        this.pack();
    }

    private void makeBassStave() {
        Stave[] tempStaveArray = new Stave[this.score.size()];
        for (int i = 0; i < this.staveArray.length; ++i) {
            tempStaveArray[i] = new BassStave();
        }
        this.updateAllStaves(tempStaveArray);
    }

    private void makePianoStave() {
        Stave[] tempStaveArray = new Stave[this.score.size()];
        for (int i = 0; i < tempStaveArray.length; ++i) {
            tempStaveArray[i] = new PianoStave();
        }
        this.updateAllStaves(tempStaveArray);
    }

    private void makeGrandStave() {
        Stave[] tempStaveArray = new Stave[this.score.size()];
        for (int i = 0; i < tempStaveArray.length; ++i) {
            tempStaveArray[i] = new GrandStave();
        }
        this.updateAllStaves(tempStaveArray);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.close) {
            this.dispose();
        } else if (e.getSource() == this.newStave) {
            new Notate();
        } else if (e.getSource() == this.open) {
            this.openMidi();
        } else if (e.getSource() == this.openjm) {
            this.openJM();
        } else if (e.getSource() == this.openJmXml) {
            this.openJMXML();
        } else if (e.getSource() == this.keySig) {
            for (int i = 0; i < this.staveArray.length; ++i) {
                if (this.staveArray[i].getKeySignature() == 0) {
                    this.staveArray[i].setKeySignature(2);
                    this.staveArray[i].repaint();
                    continue;
                }
                this.staveArray[i].setKeySignature(0);
                this.staveArray[i].repaint();
            }
        } else if (e.getSource() == this.timeSig) {
            for (int i = 0; i < this.staveArray.length; ++i) {
                if (this.staveArray[i].getMetre() == 0.0) {
                    this.staveArray[i].setMetre(4.0);
                    this.staveArray[i].repaint();
                    continue;
                }
                this.staveArray[i].setMetre(0.0);
                this.staveArray[i].repaint();
            }
        } else if (e.getSource() == this.saveJM) {
            this.saveJM();
        } else if (e.getSource() == this.saveJmXml) {
            this.saveJMXML();
        } else if (e.getSource() == this.saveMidi) {
            this.saveMidi();
        } else if (e.getSource() == this.quit) {
            System.exit(0);
        } else if (e.getSource() == this.delete) {
            for (int i = 0; i < this.staveArray.length; ++i) {
                this.staveArray[i].deleteLastNote();
            }
        } else if (e.getSource() == this.clear) {
            for (int i = 0; i < this.staveArray.length; ++i) {
                this.staveArray[i].getPhrase().empty();
                this.staveArray[i].repaint();
            }
        } else if (e.getSource() == this.trebleStave) {
            this.setCursor(new Cursor(3));
            this.makeTrebleStave();
            for (int i = 0; i < this.staveArray.length; ++i) {
                this.staveArray[i].repaint();
            }
            this.setCursor(new Cursor(0));
        } else if (e.getSource() == this.bassStave) {
            this.setCursor(new Cursor(3));
            this.makeBassStave();
            for (int i = 0; i < this.staveArray.length; ++i) {
                this.staveArray[i].repaint();
            }
            this.setCursor(new Cursor(0));
        } else if (e.getSource() == this.pianoStave) {
            this.setCursor(new Cursor(3));
            this.makePianoStave();
            for (int i = 0; i < this.staveArray.length; ++i) {
                this.staveArray[i].repaint();
            }
            this.setCursor(new Cursor(0));
        } else if (e.getSource() == this.grandStave) {
            this.setCursor(new Cursor(3));
            this.makeGrandStave();
            for (int i = 0; i < this.staveArray.length; ++i) {
                this.staveArray[i].repaint();
            }
            this.setCursor(new Cursor(0));
        } else if (e.getSource() == this.automaticStave) {
            this.setCursor(new Cursor(3));
            this.makeAppropriateStaves();
            for (int i = 0; i < this.staveArray.length; ++i) {
                this.staveArray[i].repaint();
            }
            this.setCursor(new Cursor(0));
        } else if (e.getSource() == this.setParameters) {
            ParmScreen parmScreen = new ParmScreen(this);
            double oldTempo = this.staveArray[0].getPhrase().getTempo();
            parmScreen.getParms(this.staveArray[0].getPhrase(), 15, 15);
            this.repaint();
        } else if (e.getSource() == this.playAll) {
            Play.midi(this.score, false);
        } else if (e.getSource() == this.repeatAll) {
            Play.midiCycle(this.score);
        } else if (e.getSource() == this.stopPlay) {
            Play.stopMidi();
            Play.stopMidiCycle();
        } else if (e.getSource() == this.repeatMeasure) {
            Play.midiCycle(this.getLastMeasure());
        } else if (e.getSource() == this.playMeasure) {
            Play.midi(this.getLastMeasure(), false);
        } else if (e.getSource() == this.addNotes) {
            LetterNotesEditor notesScreen = new LetterNotesEditor(this);
            notesScreen.getNotes(this.staveArray[0]);
            this.staveArray[0].repaint();
        } else if (e.getSource() == this.adjustTiming) {
            Notate.adjustTimeValues(this.staveArray[0].getPhrase());
            this.staveArray[0].repaint();
        } else if (e.getSource() == this.viewDetails) {
            PhraseViewer phraseViewer = new PhraseViewer(this);
            phraseViewer.showPhrase(this.staveArray[0], this.staveArray[0].getPhrase(), 15, 15);
        } else if (e.getSource() == this.viewZoom) {
            if (!this.zoomed) {
                CpnZoomScreen zoomSelector = new CpnZoomScreen(this);
                this.beforeZoom = this.staveArray[0].getPhrase().copy();
                this.afterZoom = this.staveArray[0].getPhrase().copy();
                this.beforeZoom.empty();
                this.afterZoom.empty();
                zoomSelector.zoomIn(this.beforeZoom, this.staveArray[0].getPhrase(), this.afterZoom);
                if (this.beforeZoom.size() + this.afterZoom.size() > 0) {
                    this.zoomed = true;
                    this.viewZoom.setLabel("View complete phrase");
                    this.repaint();
                }
            } else {
                CpnZoomScreen.zoomOut(this.beforeZoom, this.staveArray[0].getPhrase(), this.afterZoom);
                this.zoomed = false;
                this.viewZoom.setLabel("View phrase section");
                this.repaint();
            }
        } else if (e.getSource() == this.barNumbers) {
            for (int i = 0; i < this.staveArray.length; ++i) {
                this.staveArray[i].setBarNumbers(!this.staveArray[i].getBarNumbers());
                this.staveArray[i].repaint();
            }
        } else if (e.getSource() == this.viewTitle) {
            this.toggleDisplayTitle();
        }
    }

    public void openMidi() {
        Score s = new Score();
        FileDialog loadMidi = new FileDialog((Frame)this, "Select a MIDI file.", 0);
        loadMidi.setDirectory(this.lastDirectory);
        loadMidi.setFile(this.lastFileName);
        loadMidi.show();
        String fileName = loadMidi.getFile();
        if (fileName != null) {
            this.lastFileName = fileName;
            this.lastDirectory = loadMidi.getDirectory();
            Read.midi(s, this.lastDirectory + fileName);
            this.setNewScore(s);
        }
    }

    private void setNewScore(Score score) {
        this.score = score;
        this.setupArrays();
        this.makeAppropriateStaves();
    }

    public void openJM() {
        FileDialog loadjm = new FileDialog((Frame)this, "Select a jm score file.", 0);
        loadjm.setDirectory(this.lastDirectory);
        loadjm.show();
        String fileName = loadjm.getFile();
        if (fileName != null) {
            Score s = new Score();
            this.lastDirectory = loadjm.getDirectory();
            Read.jm(s, this.lastDirectory + fileName);
            this.setNewScore(s);
        }
    }

    public void openJMXML() {
        FileDialog loadjmxml = new FileDialog((Frame)this, "Select a jMusic XML score file.", 0);
        loadjmxml.setDirectory(this.lastDirectory);
        loadjmxml.show();
        String fileName = loadjmxml.getFile();
        if (fileName != null) {
            Score s = new Score();
            this.lastDirectory = loadjmxml.getDirectory();
            Read.xml(s, this.lastDirectory + fileName);
            this.setNewScore(s);
        }
    }

    public void saveMidi() {
        FileDialog fd = new FileDialog((Frame)this, "Save as a MIDI file...", 1);
        fd.show();
        if (fd.getFile() != null) {
            Write.midi(this.score, fd.getDirectory() + fd.getFile());
        }
    }

    public void saveJM() {
        FileDialog fd = new FileDialog((Frame)this, "Save as a jm file...", 1);
        fd.show();
        if (fd.getFile() != null) {
            Write.jm(this.score, fd.getDirectory() + fd.getFile());
        }
    }

    public void saveJMXML() {
        FileDialog fd = new FileDialog((Frame)this, "Save as a jMusic XML file...", 1);
        fd.show();
        if (fd.getFile() != null) {
            Write.xml(this.score, fd.getDirectory() + fd.getFile());
        }
    }

    public Phrase readMidiPhrase() {
        FileDialog loadMidi = new FileDialog((Frame)this, "Select a MIDI file.", 0);
        loadMidi.show();
        String fileName = loadMidi.getFile();
        Phrase phr = new Phrase(0.0);
        Score scr = new Score();
        if (fileName != null) {
            Read.midi(scr, loadMidi.getDirectory() + fileName);
        }
        scr.clean();
        if (scr.size() > 0 && scr.getPart(0).size() > 0) {
            phr = scr.getPart(0).getPhrase(0);
        }
        return phr;
    }

    private Score getLastMeasure() {
        double endTime;
        int numbOfCompleteBars;
        double beats = this.phraseArray[0].getNumerator();
        double startOflastBar = beats * (double)(numbOfCompleteBars = (int)((endTime = this.score.getEndTime()) / beats));
        if (startOflastBar == endTime) {
            startOflastBar -= beats;
        }
        Score oneBar = this.score.copy(startOflastBar, endTime);
        for (int i = 0; i < oneBar.size(); ++i) {
            oneBar.getPart(i).getPhrase(0).setStartTime(0.0);
        }
        return oneBar;
    }

    public void toggleDisplayTitle() {
        for (int i = 0; i < this.staveArray.length; ++i) {
            this.staveArray[i].setDisplayTitle(!this.staveArray[i].getDisplayTitle());
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.dispose();
        }
        if (e.getSource() == this.keyDialog) {
            this.keyDialog.dispose();
        }
        if (e.getSource() == this.timeDialog) {
            this.timeDialog.dispose();
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    class PlayRepeater
    extends Thread {
        JmMidiPlayer midiPlayer;
        Notate n;

        public PlayRepeater(String str, Notate nParm, JmMidiPlayer midiPlayerParm) {
            super(str);
            this.n = nParm;
            this.midiPlayer = midiPlayerParm;
        }

        public void run() {
            do {
                this.midiPlayer.play();
            } while (!this.n.timeToStop);
        }
    }
}

