/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.StringTokenizer;
import java.util.Vector;
import jm.music.data.Phrase;

public class ParmScreen
extends Dialog
implements ActionListener,
WindowListener {
    private List instrumentList;
    private List volumeList;
    private List tempoList;
    private Button instrumentButton;
    private Button volumeButton;
    private Button tempoButton;
    private Button closeButton;
    private Label instrumentLabel;
    private Label volumeLabel;
    private Label tempoLabel;
    private Phrase phrase;

    public ParmScreen(Frame parentFrame) {
        super(parentFrame, "Set Music Parameters", true);
        this.initializeLists();
        this.initializeButtons();
        this.initializeLabels();
        this.setSize(500, 400);
        this.placeControls();
        this.addWindowListener(this);
        this.setVisible(false);
        this.pack();
    }

    private static double getTempo(String s) {
        return new Double(ParmScreen.pullFirst(s));
    }

    private static int getVolume(String s) {
        return new Integer(ParmScreen.pullLast(s));
    }

    private static int getInstrument(String s) {
        return new Integer(ParmScreen.pullLast(s));
    }

    private static String pullFirst(String s) {
        StringTokenizer t = new StringTokenizer(s);
        String answer = "";
        while (answer == "" && t.hasMoreTokens()) {
            answer = t.nextToken();
        }
        return answer;
    }

    private static String pullLast(String s) {
        StringTokenizer t = new StringTokenizer(s);
        String answer = "";
        String tString = "";
        while (t.hasMoreTokens()) {
            tString = t.nextToken();
            if (tString == "") continue;
            answer = tString;
        }
        return answer;
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.dispose();
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void getParms(Phrase thePhrase, int locX, int locY) {
        this.phrase = thePhrase;
        this.setLocation(locX, locY);
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.tempoButton) {
            System.out.print("Adjusting Tempo ");
            System.out.print(this.tempoList.getSelectedItem());
            double oldTempo = this.phrase.getTempo();
            if (oldTempo < 10.0) {
                oldTempo = 60.0;
            }
            double newTempo = ParmScreen.getTempo(this.tempoList.getSelectedItem());
            this.phrase.setTempo(newTempo);
            this.multiplyTimesBy(oldTempo / newTempo);
        } else if (e.getSource() == this.volumeButton) {
            this.setVolume(ParmScreen.getVolume(this.volumeList.getSelectedItem()));
        } else if (e.getSource() == this.instrumentButton) {
            this.phrase.setInstrument(ParmScreen.getInstrument(this.instrumentList.getSelectedItem()));
        } else if (e.getSource() == this.closeButton) {
            this.dispose();
        }
    }

    private void initializeLists() {
        this.initializeInstrumentList();
        this.initializeVolumeList();
        this.initializeTempoList();
    }

    private void initializeInstrumentList() {
        this.instrumentList = new List();
        this.instrumentList.add("Accordion             21");
        this.instrumentList.add("Applausen            126");
        this.instrumentList.add("Bandneon              23");
        this.instrumentList.add("Banjo                105");
        this.instrumentList.add("Bagpipes             109");
        this.instrumentList.add("Bass   (Acoustic)     32");
        this.instrumentList.add("Bass   (Fingerd)      33");
        this.instrumentList.add("Bass   (Fretless)     35");
        this.instrumentList.add("Bass   (Picked)       34");
        this.instrumentList.add("Bass   (Slap)         36");
        this.instrumentList.add("Bass   (Synth)        38");
        this.instrumentList.add("Bass   (Synth)        38");
        this.instrumentList.add("Bassoon               70");
        this.instrumentList.add("Bottle                76");
        this.instrumentList.add("Brass  (Synthetic)    62");
        this.instrumentList.add("Calliope              82");
        this.instrumentList.add("Celeste                8");
        this.instrumentList.add("Cello                 42");
        this.instrumentList.add("Charang               84");
        this.instrumentList.add("Choir                 52");
        this.instrumentList.add("Clarinet              71");
        this.instrumentList.add("Clavinet               7");
        this.instrumentList.add("Contrabass            43");
        this.instrumentList.add("English Horn          69");
        this.instrumentList.add("Fiddle               110");
        this.instrumentList.add("French Horn           60");
        this.instrumentList.add("Flute                 73");
        this.instrumentList.add("Glockenspiel           9");
        this.instrumentList.add("Guitar (Clean)        27");
        this.instrumentList.add("Guitar (Distorted)    30");
        this.instrumentList.add("Guitar Harmonics      31");
        this.instrumentList.add("Guitar (Jazz)         26");
        this.instrumentList.add("Guitar (Muted)        28");
        this.instrumentList.add("Guitar (Nylon)        24");
        this.instrumentList.add("Guitar (Overdrive)    29");
        this.instrumentList.add("Guitar (Steel)        25");
        this.instrumentList.add("Harmonica             22");
        this.instrumentList.add("Harp                  46");
        this.instrumentList.add("Harpsichord           76");
        this.instrumentList.add("Marimba               12");
        this.instrumentList.add("Music Box             10");
        this.instrumentList.add("Oboe                  68");
        this.instrumentList.add("Ocarina               79");
        this.instrumentList.add("Orchestra Hit         55");
        this.instrumentList.add("Organ                 16");
        this.instrumentList.add("Organ (Church)        19");
        this.instrumentList.add("Organ (Reed)          20");
        this.instrumentList.add("Pan Flute             75");
        this.instrumentList.add("Piano                  0");
        this.instrumentList.add("Piano (Electric)       4");
        this.instrumentList.add("Piano (Honkeytonk)     3");
        this.instrumentList.add("Piccolo               72");
        this.instrumentList.add("Recorder              74");
        this.instrumentList.add("Saxophone (Alto)      65");
        this.instrumentList.add("Saxophone (Soprano)   64");
        this.instrumentList.add("Saxophone (Tenor)     66");
        this.instrumentList.add("Saxophone (Baritone)  67");
        this.instrumentList.add("Shakuhachi            77");
        this.instrumentList.add("Steel Drums          114");
        this.instrumentList.add("Strings               48");
        this.instrumentList.add("Strings (Pizzicato)   45");
        this.instrumentList.add("Strings (Slow)        51");
        this.instrumentList.add("Strings (Synth)       50");
        this.instrumentList.add("Strings (Tremolo)     44");
        this.instrumentList.add("Tom-Tom              119");
        this.instrumentList.add("Trombone              57");
        this.instrumentList.add("Trumpet               56");
        this.instrumentList.add("Trumpet (Muted)       59");
        this.instrumentList.add("Tuba                  58");
        this.instrumentList.add("Tubular Bell          14");
        this.instrumentList.add("Timpani               47");
        this.instrumentList.add("Vibraphone            11");
        this.instrumentList.add("Viola                 41");
        this.instrumentList.add("Violin                40");
        this.instrumentList.add("Voice                 53");
        this.instrumentList.add("Vox                   56");
        this.instrumentList.add("Whistle               78");
        this.instrumentList.add("Wood Block           115");
        this.instrumentList.add("Xylophone             13");
    }

    private void initializeVolumeList() {
        this.volumeList = new List();
        int minVolume = 7;
        int maxVolume = 256;
        int volumeStep = 6;
        for (int i = minVolume; i <= maxVolume; i += volumeStep) {
            this.volumeList.add(new Integer(i).toString());
        }
    }

    private void initializeTempoList() {
        this.tempoList = new List();
        for (double x = 36.0; x < 143.0; x += 2.0) {
            this.tempoList.add(new Double(x).toString());
        }
        for (double y = 144.0; y < 250.0; y += 4.0) {
            this.tempoList.add(new Double(y).toString());
        }
        for (double z = 256.0; z < 404.0; z += 8.0) {
            this.tempoList.add(new Double(z).toString());
        }
    }

    private void initializeButtons() {
        this.instrumentButton = new Button("Apply");
        this.volumeButton = new Button("Apply");
        this.tempoButton = new Button("Apply");
        this.closeButton = new Button("Close");
    }

    private void initializeLabels() {
        this.instrumentLabel = new Label("Instrument");
        this.volumeLabel = new Label("Volume");
        this.tempoLabel = new Label("Tempo");
    }

    private void placeControls() {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(layout);
        c.fill = 1;
        c.weightx = 0.5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 3;
        layout.setConstraints(this.instrumentLabel, c);
        this.add(this.instrumentLabel);
        c.gridx = 1;
        layout.setConstraints(this.instrumentList, c);
        this.add(this.instrumentList);
        c.gridwidth = 0;
        c.gridx = 2;
        Panel ibPanel = new Panel();
        ibPanel.add(this.instrumentButton);
        layout.setConstraints(ibPanel, c);
        this.add(ibPanel);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 3;
        layout.setConstraints(this.volumeLabel, c);
        this.add(this.volumeLabel);
        c.gridx = 1;
        layout.setConstraints(this.volumeList, c);
        this.add(this.volumeList);
        c.gridwidth = 0;
        c.gridx = 2;
        Panel vbPanel = new Panel();
        vbPanel.add(this.volumeButton);
        layout.setConstraints(vbPanel, c);
        this.add(vbPanel);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 4;
        layout.setConstraints(this.tempoLabel, c);
        this.add(this.tempoLabel);
        c.gridx = 1;
        layout.setConstraints(this.tempoList, c);
        this.add(this.tempoList);
        c.gridwidth = 0;
        c.gridx = 2;
        Panel tbPanel = new Panel();
        tbPanel.add(this.tempoButton);
        layout.setConstraints(tbPanel, c);
        this.add(tbPanel);
        c.gridwidth = 1;
        c.gridx = 1;
        c.gridy = 5;
        layout.setConstraints(this.closeButton, c);
        this.add(this.closeButton);
        this.instrumentButton.addActionListener(this);
        this.volumeButton.addActionListener(this);
        this.tempoButton.addActionListener(this);
        this.closeButton.addActionListener(this);
    }

    private void setVolume(int newVol) {
        Vector noteList = this.phrase.getNoteList();
        for (int i = 0; i < noteList.size(); ++i) {
            if (this.phrase.getNote(i).getDynamic() == 0) continue;
            this.phrase.getNote(i).setDynamic(newVol);
        }
    }

    private void multiplyTimesBy(double newFactor) {
        Vector noteList = this.phrase.getNoteList();
        System.out.println(newFactor);
        for (int i = 0; i < noteList.size(); ++i) {
        }
    }
}

