/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import jm.JMC;
import jm.gui.cpn.Images;
import jm.gui.cpn.StaveActionHandler;
import jm.gui.cpn.ToolkitImages;
import jm.music.data.Phrase;
import jm.music.tools.Mod;

public abstract class Stave
extends Panel
implements JMC,
KeyListener {
    public Image image;
    public int staveSpaceHeight = 8;
    public int rightMargin = 20;
    public int beatWidth = 43;
    public int staveWidth = this.beatWidth * 15;
    public int imageHeightOffset = 28;
    public int clefWidth = 38;
    public int timeSigWidth = 5;
    public int keySigWidth = 5;
    public int bPos = 28;
    public Vector notePositions = new Vector();
    protected boolean requiresMoreThanOneImage = false;
    protected double excessRhythmValue = 0.0;
    protected boolean isUp = true;
    protected boolean isNote = false;
    protected Graphics g;
    protected Image trebleClef;
    protected Image bassClef;
    protected Image crotchetUp;
    protected Image crotchetDown;
    protected Image quaverDown;
    protected Image quaverUp;
    protected Image semiquaverDown;
    protected Image semiquaverUp;
    protected Image minimDown;
    protected Image minimUp;
    protected Image semibreve;
    protected Image dot;
    protected Image semiquaverRest;
    protected Image quaverRest;
    protected Image crotchetRest;
    protected Image minimRest;
    protected Image semibreveRest;
    protected Image sharp;
    protected Image flat;
    protected Image natural;
    protected Image one;
    protected Image two;
    protected Image three;
    protected Image four;
    protected Image five;
    protected Image six;
    protected Image seven;
    protected Image eight;
    protected Image nine;
    protected Image delete;
    protected Image tieOver;
    protected Image tieUnder;
    protected Phrase phrase;
    protected Image currImage;
    protected int currBeatWidth;
    protected int totalBeatWidth;
    protected boolean dottedNote = false;
    protected int[] notePosOffset = new int[]{24, 24, 20, 20, 16, 12, 12, 8, 8, 4, 4, 0};
    protected double metre = 4.0;
    protected int keySignature = 0;
    protected int[] sharps = new int[]{77, 72, 79, 74, 69, 76, 71};
    protected int[] flats = new int[]{71, 76, 69, 74, 67, 72, 65};
    protected Vector previouslyChromatic = new Vector();
    protected int[] lineNotes = new int[]{0, 1, 4, 7, 8, 11, 14, 15, 17, 18, 21, 22};
    protected int maxPitch = 127;
    protected int minPitch = 0;
    protected String title;
    protected boolean barNumbers = false;
    protected boolean editable = true;
    protected boolean qtOn = false;
    protected int panelHeight = 110;
    protected int staveDelta = 0;
    protected boolean displayTitle = false;
    protected Font font = new Font("Helvetica", 0, 10);
    protected int spacingValue = 70;

    public Stave() {
        this(new Phrase(), new ToolkitImages());
    }

    public Stave(Phrase phrase) {
        this(phrase, new ToolkitImages());
    }

    public Stave(Images images) {
        this(new Phrase(), images);
    }

    public Stave(Phrase phr, Images images) {
        this.title = phr.getTitle();
        this.phrase = this.addRequiredRests(phr);
        this.setBackground(Color.getHSBColor(0.14f, 0.09f, 1.0f));
        this.setSize(this.beatWidth * this.spacingValue, this.panelHeight);
        if (this.getSize().width < (int)(this.phrase.getEndTime() * (double)this.beatWidth * 1.5)) {
            this.setSize((int)(this.phrase.getEndTime() * (double)this.beatWidth * 1.5), this.panelHeight);
        }
        StaveActionHandler handleActions = new StaveActionHandler(this);
        this.addMouseListener(handleActions);
        this.addMouseMotionListener(handleActions);
        this.trebleClef = images.getTrebleClef();
        this.bassClef = images.getBassClef();
        this.crotchetDown = images.getCrotchetDown();
        this.crotchetUp = images.getCrotchetUp();
        this.quaverDown = images.getQuaverDown();
        this.quaverUp = images.getQuaverUp();
        this.semiquaverDown = images.getSemiquaverDown();
        this.semiquaverUp = images.getSemiquaverUp();
        this.minimDown = images.getMinimDown();
        this.minimUp = images.getMinimUp();
        this.semibreve = images.getSemibreve();
        this.dot = images.getDot();
        this.semiquaverRest = images.getSemiquaverRest();
        this.quaverRest = images.getQuaverRest();
        this.crotchetRest = images.getCrotchetRest();
        this.minimRest = images.getMinimRest();
        this.semibreveRest = images.getSemibreveRest();
        this.sharp = images.getSharp();
        this.flat = images.getFlat();
        this.natural = images.getNatural();
        this.one = images.getOne();
        this.two = images.getTwo();
        this.three = images.getThree();
        this.four = images.getFour();
        this.five = images.getFive();
        this.six = images.getSix();
        this.seven = images.getSeven();
        this.eight = images.getEight();
        this.nine = images.getNine();
        this.delete = images.getDelete();
        this.tieOver = images.getTieOver();
        this.tieUnder = images.getTieUnder();
    }

    public Phrase addRequiredRests(Phrase phrase) {
        if (phrase.getStartTime() > 0.0) {
            double remTime;
            Phrase tempPhrase = new Phrase(0.0);
            for (remTime = phrase.getStartTime(); remTime >= 4.0; remTime -= 4.0) {
                tempPhrase.addNote(Integer.MIN_VALUE, 4.0);
            }
            while (remTime >= 1.0) {
                tempPhrase.addNote(Integer.MIN_VALUE, 1.0);
                remTime -= 1.0;
            }
            tempPhrase.addNote(Integer.MIN_VALUE, remTime);
            Mod.append(tempPhrase, phrase);
            phrase = tempPhrase;
        }
        return phrase;
    }

    public Phrase getPhrase() {
        return this.phrase;
    }

    public void setPhrase(Phrase phr) {
        this.phrase = this.addRequiredRests(phr);
        this.previouslyChromatic.removeAllElements();
        this.repaint();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.phrase != null) {
            this.phrase.setTitle(title);
        }
    }

    public void removeTitle() {
        this.title = null;
    }

    public boolean getDisplayTitle() {
        return this.displayTitle;
    }

    public void setDisplayTitle(boolean value) {
        this.displayTitle = value;
        this.repaint();
    }

    public int getPanelHeight() {
        return this.panelHeight;
    }

    public double getMetre() {
        return this.metre;
    }

    public void setMetre(double timeSig) {
        this.metre = timeSig;
    }

    public int getMajorKey() {
        int[] keys = new int[]{11, 6, 1, 8, 3, 10, 5, 0, 7, 2, 9, 4, 11, 6, 1};
        return keys[this.keySignature + 7];
    }

    public int getKeySignature() {
        return this.keySignature;
    }

    public void setKeySignature(int key) {
        this.keySignature = key;
    }

    public void setEditable(boolean state) {
        this.editable = state;
    }

    public int getMinPitch() {
        return this.minPitch;
    }

    public void setMinPitch(int min) {
        this.minPitch = min;
    }

    public int getMaxPitch() {
        return this.maxPitch;
    }

    public void setMaxPitch(int max) {
        this.maxPitch = max;
    }

    public int getTotalBeatWidth() {
        return this.totalBeatWidth;
    }

    public void setTotalBeatWidth(int width) {
        this.totalBeatWidth = width;
    }

    public boolean getBarNumbers() {
        return this.barNumbers;
    }

    public void setBarNumbers(boolean show) {
        this.barNumbers = show;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getSize().width, this.getSize().height);
    }

    public boolean getQtOn() {
        return this.qtOn;
    }

    public void setQtOn(boolean state) {
        this.qtOn = state;
    }

    public void updateChange() {
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics graphics) {
    }

    public void deleteLastNote() {
        if (this.phrase.size() > 0) {
            this.phrase.removeNote(this.phrase.size() - 1);
            this.repaint();
            this.updateChange();
        }
    }

    protected void chooseImage(int pitch, double rhythmValue, int upPitch1, int downPitch, int upPitch2) {
        if (pitch == Integer.MIN_VALUE) {
            this.isNote = false;
            if (rhythmValue <= 0.0) {
                this.currImage = this.delete;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
            } else if (rhythmValue <= 0.2501) {
                this.currImage = this.semiquaverRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
            } else if (rhythmValue <= 0.501) {
                this.currImage = this.quaverRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.6666666666666666);
            } else if (rhythmValue <= 0.7501) {
                this.currImage = this.quaverRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.6666666666666666);
                this.dottedNote = true;
            } else if (rhythmValue <= 1.001) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = this.beatWidth;
            } else if (rhythmValue <= 1.2501) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = this.beatWidth;
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = rhythmValue - 1.0;
            } else if (rhythmValue <= 1.501) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                this.dottedNote = true;
            } else if (rhythmValue <= 1.7501) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                this.dottedNote = true;
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = rhythmValue - 1.5;
            } else if (rhythmValue <= 2.001) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
            } else if (rhythmValue <= 2.7501) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = rhythmValue - 2.0;
            } else if (rhythmValue <= 3.001) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                this.dottedNote = true;
            } else if (rhythmValue <= 3.7501) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                this.dottedNote = true;
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = rhythmValue - 3.0;
            } else if (rhythmValue <= 4.001) {
                this.currImage = this.semibreveRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
            } else {
                this.currImage = this.semibreveRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = rhythmValue - 4.0;
            }
        } else {
            this.isNote = true;
            if (pitch < upPitch1 && pitch >= downPitch || pitch < upPitch2) {
                this.isUp = true;
                if (rhythmValue <= 0.001) {
                    this.currImage = this.delete;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                } else if (rhythmValue <= 0.2501) {
                    this.currImage = this.semiquaverUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                } else if (rhythmValue <= 0.501) {
                    this.currImage = this.quaverUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.6666666666666666);
                } else if (rhythmValue <= 0.7501) {
                    this.currImage = this.quaverUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.67);
                    this.dottedNote = true;
                } else if (rhythmValue <= 1.001) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = this.beatWidth;
                } else if (rhythmValue <= 1.2501) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = this.beatWidth;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 1.0;
                } else if (rhythmValue <= 1.501) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                } else if (rhythmValue <= 1.7501) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 1.5;
                } else if (rhythmValue <= 2.001) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                } else if (rhythmValue <= 2.7501) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 2.0;
                } else if (rhythmValue <= 3.001) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                } else if (rhythmValue <= 3.7501) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 3.0;
                } else if (rhythmValue <= 4.001) {
                    this.currImage = this.semibreve;
                    this.currBeatWidth = (int)((double)this.beatWidth * 2.25);
                } else {
                    this.currImage = this.semibreve;
                    this.currBeatWidth = (int)((double)this.beatWidth * 2.25);
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 4.0;
                }
            } else {
                this.isUp = false;
                if (rhythmValue <= 0.001) {
                    this.currImage = this.delete;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                } else if (rhythmValue <= 0.2501) {
                    this.currImage = this.semiquaverDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                } else if (rhythmValue <= 0.501) {
                    this.currImage = this.quaverDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.6666666666666666);
                } else if (rhythmValue <= 0.7501) {
                    this.currImage = this.quaverDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.6666666666666666);
                    this.dottedNote = true;
                } else if (rhythmValue <= 1.001) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = this.beatWidth;
                } else if (rhythmValue <= 1.2501) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = this.beatWidth;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 1.0;
                } else if (rhythmValue <= 1.501) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                } else if (rhythmValue <= 1.7501) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 1.5;
                } else if (rhythmValue <= 2.001) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                } else if (rhythmValue <= 2.7501) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 2.0;
                } else if (rhythmValue <= 3.001) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                } else if (rhythmValue <= 3.7501) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 3.0;
                } else if (rhythmValue <= 4.001) {
                    this.currImage = this.semibreve;
                    this.currBeatWidth = (int)((double)this.beatWidth * 2.25);
                } else {
                    this.currImage = this.semibreve;
                    this.currBeatWidth = (int)((double)this.beatWidth * 2.25);
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = rhythmValue - 4.0;
                }
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        System.out.println(e.getKeyChar());
    }
}

