/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.wave;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import jm.JMC;

public class WaveFileReader
implements JMC {
    private File file;
    private AudioFileFormat fileFormat;
    private AudioFormat format;
    private int bits;
    private String fileType;
    private boolean cache;
    private long duration;
    private InputStream is;
    private boolean wholeFile = false;
    private boolean bigEndian;
    private int channels;
    private int sampleRate;

    public WaveFileReader(String fileName) {
        try {
            this.file = new File(fileName);
            this.fileFormat = AudioSystem.getAudioFileFormat(this.file);
            this.format = this.fileFormat.getFormat();
            this.bigEndian = this.format.isBigEndian();
            this.channels = this.format.getChannels();
            this.sampleRate = (int)this.format.getSampleRate();
            this.duration = (long)this.fileFormat.getFrameLength() * (long)this.channels;
            this.bits = this.format.getSampleSizeInBits() / 8;
            this.fileType = this.fileFormat.toString();
            this.is = AudioSystem.getAudioInputStream(this.file);
        }
        catch (UnsupportedAudioFileException uafe) {
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void finalize() {
        try {
            this.is.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public float[] getSamples(int segmentSize, int startPos) {
        float[] samples = new float[segmentSize];
        try {
            this.is = AudioSystem.getAudioInputStream(this.file);
            this.is.read(new byte[startPos * this.bits]);
            byte[] byteArray = new byte[this.bits * segmentSize];
            this.is.read(byteArray);
            int k = 0;
            for (int i = 0; i < segmentSize; ++i) {
                byte[] tempBytes = new byte[this.bits];
                for (int j = 0; j < this.bits; ++j) {
                    tempBytes[j] = byteArray[k++];
                }
                samples[i] = this.getFloat(tempBytes);
            }
        }
        catch (UnsupportedAudioFileException uafe) {
            System.out.println("jMusic WaveFileReader error: This file format is not supported.");
            System.exit(0);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return samples;
    }

    public int getWaveSize() {
        return (int)(this.duration / (long)this.channels);
    }

    public int getNumOfBytes() {
        return (int)(this.duration * (long)this.bits);
    }

    public int getBits() {
        return this.bits;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getBitResolution() {
        int depth = -1;
        switch (this.bits) {
            case 1: {
                depth = 8;
                break;
            }
            case 2: {
                depth = 16;
                break;
            }
            case 3: {
                depth = 24;
                break;
            }
            case 4: {
                depth = 32;
            }
        }
        return depth;
    }

    private float getFloat(byte[] b) {
        float sample = 0.0f;
        int ret = 0;
        int length = b.length;
        int i = 0;
        while (i < b.length) {
            ret |= (b[i] & 0xFF) << (this.bigEndian ? length : i + 1) * 8 - 8;
            ++i;
            --length;
        }
        switch (this.bits) {
            case 1: {
                if (ret > 127) {
                    ret = ~ret + 1;
                    ret &= 0x7F;
                    ret = ~ret + 1;
                }
                sample = (float)ret / 127.0f;
                break;
            }
            case 2: {
                if (ret > Short.MAX_VALUE) {
                    ret = ~ret + 1;
                    ret &= Short.MAX_VALUE;
                    ret = ~ret + 1;
                }
                sample = (float)ret / 32767.0f;
                break;
            }
            case 3: {
                if (ret > 0x7FFFFF) {
                    ret = ~ret + 1;
                    ret &= 0x7FFFFF;
                    ret = ~ret + 1;
                }
                sample = (float)ret / 8388608.0f;
                break;
            }
            case 4: {
                sample = (float)ret / 2.1474836E9f;
                break;
            }
            default: {
                System.err.println("Format not accepted");
            }
        }
        return sample;
    }
}

