/*
 * Decompiled with CFR 0.152.
 */
package jm.midi;

import java.awt.Frame;
import java.awt.List;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Transmitter;

public abstract class MidiCommunication
implements Receiver {
    private Receiver midiReceiver;
    private boolean waitingToSetup = true;

    public MidiCommunication() {
        this.setupMidiInput();
        while (this.waitingToSetup) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    public MidiCommunication(boolean prompt) {
        if (prompt) {
            this.setupMidiInput();
            while (this.waitingToSetup) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
    }

    public MidiCommunication(int inputDeviceID, int outputDeviceID) {
        MidiDevice.Info[] info = MidiSystem.getMidiDeviceInfo();
        this.setMidiInputSelection(inputDeviceID, info);
        this.setMidiOutputSelection(outputDeviceID, info);
    }

    public void midiSetup() {
        this.setupMidiInput();
    }

    public abstract void handleMidiInput(int var1, int var2, int var3, int var4);

    public void sendMidiOutput(int status, int channel, int data1, int data2) {
        try {
            ShortMessage message = new ShortMessage();
            message.setMessage(status, channel, data1, data2);
            this.midiReceiver.send(message, -1L);
        }
        catch (InvalidMidiDataException e) {
            // empty catch block
        }
    }

    public void send(MidiMessage message, long timeStamp) {
        byte[] m = message.getMessage();
        int status = message.getStatus();
        if (message instanceof ShortMessage) {
            int type = (m[0] & 0xFF) >> 4;
            int channel = m[0] & 0xF;
            byte data1 = m[1];
            int data2 = -1;
            if (m.length > 2) {
                data2 = m[2];
            }
            if (type != 15) {
                this.handleMidiInput(status - channel, channel, data1, data2);
            } else if (status == 248) {
                System.out.print("MIDI Clock message");
            } else if (status == 254) {
                System.out.print("MIDI Active sensing message");
            } else {
                System.out.print("A non-identified MIDI system message " + status);
            }
        } else if (message instanceof SysexMessage) {
            System.out.println();
            System.out.print("Sysex MIDI message <<");
            for (int i = 0; i < m.length; ++i) {
                System.out.print(" " + m[i]);
            }
            System.out.println(">>");
        } else if (message instanceof MetaMessage) {
            System.out.println();
            System.out.print("Meta MIDI Message {");
            for (int i = 0; i < m.length; ++i) {
                System.out.print(" " + m[i]);
            }
            System.out.println("}");
        } else {
            System.out.println("Unknown MIDI message [");
            for (int i = 0; i < m.length; ++i) {
                System.out.print(" " + m[i]);
            }
            System.out.println("]");
        }
    }

    public void close() {
    }

    private void setupMidiInput() {
        try {
            final Frame f = new Frame("MIDI Input port: Double-click to select.");
            final MidiDevice.Info[] info = MidiSystem.getMidiDeviceInfo();
            final List dataList = new List();
            this.fillFrame(f, dataList, info);
            f.setVisible(true);
            MouseAdapter mouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        int index = dataList.getSelectedIndex();
                        MidiCommunication.this.setMidiInputSelection(index, info);
                        f.setVisible(false);
                        MidiCommunication.this.setupMidiOutput();
                    }
                }
            };
            dataList.addMouseListener(mouseListener);
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(0);
        }
    }

    private void setupMidiOutput() {
        try {
            final MidiDevice.Info[] info = MidiSystem.getMidiDeviceInfo();
            final Frame f = new Frame("MIDI Output port: Double-click to select.");
            final List dataList = new List();
            this.fillFrame(f, dataList, info);
            MouseAdapter mouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        int index = dataList.getSelectedIndex();
                        MidiCommunication.this.setMidiOutputSelection(index, info);
                        f.setVisible(false);
                        MidiCommunication.this.waitingToSetup = false;
                    }
                }
            };
            dataList.addMouseListener(mouseListener);
            f.setVisible(true);
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(0);
        }
    }

    private void fillFrame(Frame f, List dataList, MidiDevice.Info[] info) {
        try {
            int i;
            f.setSize(340, 200);
            f.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - 170, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - 100);
            String[] data = new String[info.length];
            data[0] = "" + info[0];
            data[1] = "" + info[1];
            for (i = 2; i < info.length; ++i) {
                data[i] = MidiSystem.getMidiDevice(info[i]).toString();
            }
            for (i = 0; i < info.length; ++i) {
                dataList.add(data[i]);
            }
            ScrollPane scrollPane = new ScrollPane();
            scrollPane.add(dataList);
            f.add(scrollPane);
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(0);
        }
    }

    private void setMidiInputSelection(int inputDeviceID, MidiDevice.Info[] info) {
        try {
            MidiDevice inputPort = MidiSystem.getMidiDevice(info[inputDeviceID]);
            inputPort.open();
            Transmitter t = inputPort.getTransmitter();
            t.setReceiver(this);
        }
        catch (Exception e) {
            System.out.println("Exception in PlumStone main ()");
            System.out.println(e);
            System.exit(0);
        }
    }

    private void setMidiOutputSelection(int outputDeviceID, MidiDevice.Info[] info) {
        try {
            MidiDevice outputPort = MidiSystem.getMidiDevice(info[outputDeviceID]);
            outputPort.open();
            this.midiReceiver = outputPort.getReceiver();
        }
        catch (Exception e) {
            System.out.println("Exception in PlumStone main ()");
            System.out.println(e);
            System.exit(0);
        }
    }
}

