/*
 * Decompiled with CFR 0.152.
 */
package jm.midi.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jm.midi.MidiUtil;
import jm.midi.event.Event;
import jm.midi.event.TempoEvent;

public final class EndTrack
implements Event {
    private final short id = (short)23;
    private int time = 0;

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public short getID() {
        return this.id;
    }

    public int write(DataOutputStream dos) throws IOException {
        int bytes_out = MidiUtil.writeVarLength(this.time, dos);
        dos.writeByte(-1);
        dos.writeByte(47);
        dos.writeByte(0);
        return bytes_out + 2;
    }

    public int read(DataInputStream dis) throws IOException {
        return 0;
    }

    public Event copy() throws CloneNotSupportedException {
        TempoEvent event;
        try {
            event = (TempoEvent)this.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println(e);
            event = new TempoEvent();
        }
        return event;
    }

    public void print() {
        System.out.println("EndTrack(023):             [time = " + this.time + "]");
    }
}

