/*
 * Decompiled with CFR 0.152.
 */
package jm.midi.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jm.midi.event.Event;
import jm.midi.event.VoiceEvt;

public final class NoteOff
implements VoiceEvt,
Cloneable {
    private final short id = (short)4;
    private short pitch;
    private short velocity;
    private short midiChannel;
    private int time;

    public NoteOff() {
        this.pitch = 0;
        this.velocity = 0;
        this.midiChannel = 0;
        this.time = 0;
    }

    public NoteOff(short pitch, short velocity, short midiChannel, int time) {
        this.pitch = pitch;
        this.velocity = velocity;
        this.midiChannel = midiChannel;
        this.time = time;
    }

    public short getPitch() {
        return this.pitch;
    }

    public void setPitch(short pitch) {
        this.pitch = pitch;
    }

    public short getVelocity() {
        return this.velocity;
    }

    public void setVelocity(short velocity) {
        this.velocity = velocity;
    }

    public short getMidiChannel() {
        return this.midiChannel;
    }

    public void setMidiChannel(short midiChannel) {
        this.midiChannel = midiChannel;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public short getID() {
        return 4;
    }

    public Event copy() throws CloneNotSupportedException {
        NoteOff event;
        try {
            event = (NoteOff)this.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println(e);
            event = new NoteOff();
        }
        return event;
    }

    public int write(DataOutputStream dos) throws IOException {
        return 0;
    }

    public int read(DataInputStream dis) throws IOException {
        this.pitch = (short)dis.readUnsignedByte();
        this.velocity = (short)dis.readUnsignedByte();
        return 2;
    }

    public void print() {
        System.out.println("Note Off(004): [time = " + this.time + "][midiChannel = " + this.midiChannel + "][pitch = " + this.pitch + "][velocity = " + this.velocity + "]");
    }
}

