/*
 * Decompiled with CFR 0.152.
 */
package jm.midi.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jm.midi.MidiUtil;
import jm.midi.event.Event;
import jm.midi.event.VoiceEvt;

public final class NoteOn
implements VoiceEvt,
Cloneable {
    private final short id = (short)5;
    private short pitch;
    private short velocity;
    private short midiChannel;
    private int time;

    public NoteOn() {
        this.pitch = 0;
        this.velocity = 0;
        this.midiChannel = 0;
        this.time = 0;
    }

    public NoteOn(short pitch, short velocity, short midiChannel, int time) {
        this.pitch = pitch;
        this.velocity = velocity;
        this.midiChannel = midiChannel;
        this.time = time;
    }

    public short getPitch() {
        return this.pitch;
    }

    public void setPitch(short pitch) {
        this.pitch = pitch;
    }

    public short getVelocity() {
        return this.velocity;
    }

    public void setVelocity(short velocity) {
        this.velocity = velocity;
    }

    public short getMidiChannel() {
        return this.midiChannel;
    }

    public void setMidiChannel(short midiChannel) {
        this.midiChannel = midiChannel;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public short getID() {
        return 5;
    }

    public Event copy() throws CloneNotSupportedException {
        NoteOn event;
        try {
            event = (NoteOn)this.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println(e);
            event = new NoteOn();
        }
        return event;
    }

    public int write(DataOutputStream dos) throws IOException {
        int bytes_out = MidiUtil.writeVarLength(this.time, dos);
        dos.writeByte((byte)(144 + this.midiChannel));
        dos.writeByte((byte)this.pitch);
        dos.writeByte((byte)this.velocity);
        return bytes_out + 3;
    }

    public int read(DataInputStream dis) throws IOException {
        this.pitch = (short)dis.readUnsignedByte();
        this.velocity = (short)dis.readUnsignedByte();
        return 2;
    }

    public void print() {
        System.out.println("Note On(005): [time = " + this.time + "][midiChannel = " + this.midiChannel + "][pitch = " + this.pitch + "][velocity = " + this.velocity + "]");
    }
}

