/*
 * Decompiled with CFR 0.152.
 */
package jm.music.data;

import java.io.Serializable;
import jm.JMC;
import jm.music.data.Phrase;

public class Note
implements Cloneable,
Serializable {
    public static final int DEFAULT_PITCH = 60;
    public static final double DEFAULT_RHYTHM_VALUE = 1.0;
    public static final int DEFAULT_DYNAMIC = 85;
    public static final double DEFAULT_PAN = 0.5;
    public static final double DEFAULT_DURATION_MULTIPLIER = 0.9;
    public static final double DEFAULT_DURATION = 0.9;
    public static final double DEFAULT_ARTICULATION = 0.9;
    public static final double DEFAULT_OFFSET = 0.0;
    public static final double DEFAULT_SAMPLE_START_TIME = 0.0;
    public static final int MIN_PITCH = 0;
    public static final double MIN_FREQUENCY = 1.0E-17;
    public static final double MAX_MIDI_PITCH = 127.0;
    public static final int MAX_PITCH = 127;
    public static final double MIN_RHYTHM_VALUE = 0.0;
    public static final double MAX_RHYTHM_VALUE = Double.MAX_VALUE;
    public static final int MIN_DYNAMIC = 0;
    public static final int MAX_DYNAMIC = 127;
    public static final double MIN_PAN = 0.0;
    public static final double MAX_PAN = Double.MAX_VALUE;
    public static final double MIN_DURATION = 0.0;
    public static final double MAX_DURATION = Double.MAX_VALUE;
    public static final int REST = Integer.MIN_VALUE;
    public static final boolean FREQUENCY = true;
    public static final boolean MIDI_PITCH = false;
    public static final int AMP_ENV = 0;
    public static final int PITCH_ENV = 1;
    public static final int FILTER_ENV = 2;
    public static final int PAN_ENV = 3;
    public static final String C = "C";
    public static final String G = "G";
    public static final String D = "D";
    public static final String A = "A";
    public static final String E = "E";
    public static final String B = "B";
    public static final String F_SHARP = "F#";
    public static final String C_SHARP = "C#";
    public static final String G_SHARP = "Ab";
    public static final String D_SHARP = "Eb";
    public static final String A_SHARP = "Bb";
    public static final String A_FLAT = "Ab";
    public static final String E_FLAT = "Eb";
    public static final String B_FLAT = "Bb";
    public static final String F = "F";
    private String noteString = "";
    private double pitch;
    private int dynamic;
    private double rhythmValue;
    private double pan;
    private double duration;
    private double offset;
    private double sampleStartTime;
    private boolean pitchType;
    private Phrase myPhrase = null;
    private double[][] breakPoints = new double[64][];

    public Note() {
        this(60, 1.0);
        this.pitch = 60.0;
        this.pitchType = false;
        this.rhythmValue = 1.0;
        this.dynamic = 85;
        this.pan = 0.5;
        this.duration = 0.9;
        this.offset = 0.0;
    }

    public Note(int pitch, double rhythmValue) {
        this(pitch, rhythmValue, 85);
    }

    public Note(int pitch, double rhythmValue, int dynamic) {
        this(pitch, rhythmValue, dynamic, 0.5);
    }

    public Note(int pitch, double rhythmValue, int dynamic, double pan) {
        if (pitch < 0 && pitch > -2147483646) {
            System.err.println("jMusic Note constructor error: Pitch is " + pitch + ", it must be no less than " + 0 + " (REST = " + Integer.MIN_VALUE + ")");
            System.exit(1);
        }
        this.pitchType = false;
        this.pitch = pitch;
        this.rhythmValue = rhythmValue;
        this.dynamic = dynamic < 0 ? 0 : (dynamic > 127 ? 127 : dynamic);
        this.pan = pan;
        this.duration = rhythmValue * 0.9;
        this.offset = 0.0;
    }

    public Note(double frequency, double rhythmValue) {
        this(frequency, rhythmValue, 85);
    }

    public Note(double frequency, double rhythmValue, int dynamic) {
        this(frequency, rhythmValue, dynamic, 0.5);
    }

    public Note(double frequency, double rhythmValue, int dynamic, double pan) {
        if (frequency > 1.0E-17) {
            this.pitch = frequency;
        } else {
            System.err.println("jMusic Note constructor error: Frequency is " + frequency + ", it must be greater than " + 1.0E-17 + " hertz.");
            System.exit(1);
        }
        this.pitchType = true;
        this.rhythmValue = rhythmValue;
        this.dynamic = dynamic < 0 ? 0 : (dynamic > 127 ? 127 : dynamic);
        this.pan = pan;
        this.duration = rhythmValue * 0.9;
        this.offset = 0.0;
    }

    public Note(String note) {
        this.noteString = note;
        this.setPitch(this.getPitchValue());
    }

    public static int freqToMidiPitch(double freq) {
        if (freq < 26.73 || freq > 14496.0) {
            System.err.println("freqToMidiPitch error: Frequency " + freq + " is not within the MIDI note range.");
            return -1;
        }
        double r = Math.pow(2.0, 0.08333333333333333);
        double cent = Math.pow(2.0, 8.333333333333334E-4);
        int r_index = 0;
        int cent_index = 0;
        double referenceFreq = 440.0;
        if (freq >= referenceFreq) {
            while (freq > r * referenceFreq) {
                referenceFreq = r * referenceFreq;
                ++r_index;
            }
            while (freq > cent * referenceFreq) {
                referenceFreq = cent * referenceFreq;
                ++cent_index;
            }
            if (cent * referenceFreq - freq < freq - referenceFreq) {
                ++cent_index;
            }
            if (cent_index > 50) {
                ++r_index;
                cent_index = 100 - cent_index;
            }
        } else {
            while (freq < referenceFreq / r) {
                referenceFreq /= r;
                --r_index;
            }
            while (freq < referenceFreq / cent) {
                referenceFreq /= cent;
                ++cent_index;
            }
            if (freq - referenceFreq / cent < referenceFreq - freq) {
                ++cent_index;
            }
            if (cent_index >= 50) {
                --r_index;
                cent_index = 100 - cent_index;
            }
        }
        return 69 + r_index;
    }

    public static double midiPitchToFreq(int midiPitch) {
        if (midiPitch < 0 || midiPitch > 127) {
            System.err.println("jMusic Note.midiPitchToFreq error:midiPitch of " + midiPitch + " is out side valid range.");
            return -1.0;
        }
        double r = Math.pow(2.0, 0.08333333333333333);
        int pitchOffset = midiPitch - 69;
        double freq = 440.0;
        if (midiPitch > 69) {
            for (int i = 69; i < midiPitch; ++i) {
                freq *= r;
            }
        } else {
            for (int i = 69; i > midiPitch; --i) {
                freq /= r;
            }
        }
        freq = (double)Math.round(freq * 1000.0) / 1000.0;
        return freq;
    }

    public static String getNote(int pitch) {
        String noteString = "";
        noteString = pitch % 12 == 0 ? C : (pitch % 12 == 1 ? C_SHARP : (pitch % 12 == 2 ? D : (pitch % 12 == 3 ? "Eb" : (pitch % 12 == 4 ? E : (pitch % 12 == 5 ? F : (pitch % 12 == 6 ? F_SHARP : (pitch % 12 == 7 ? G : (pitch % 12 == 8 ? "Ab" : (pitch % 12 == 9 ? A : (pitch % 12 == 10 ? "Bb" : (pitch % 12 == 11 ? B : "N/A")))))))))));
        return noteString;
    }

    public boolean getPitchType() {
        return this.pitchType;
    }

    public void setPitchType(boolean newType) {
        this.pitchType = newType;
    }

    public double getFrequency() {
        double frq = this.pitch;
        if (!this.pitchType && this.pitch != -2.147483648E9 && this.pitch <= 127.0 && this.pitch >= 0.0) {
            frq = JMC.FRQ[(int)this.pitch];
        }
        if (this.pitch == -2.147483648E9) {
            frq = -2.147483648E9;
        }
        return frq;
    }

    public void setFrequency(double freq) {
        try {
            this.pitch = this.pitch < 1.0E-17 ? 1.0E-17 : freq;
            this.pitchType = true;
        }
        catch (RuntimeException re) {
            System.err.println("Error setting note value: You must enter frequency values above 1.0E-17");
            System.exit(1);
        }
    }

    public int getPitch() {
        if (this.pitchType && this.pitch != -2.147483648E9) {
            System.err.println("jMusic error getting Note pitch: Pitch is a frequency - getPitch() can't be used.");
            System.exit(1);
        }
        int val = this.pitch < -2.147483646E9 ? Integer.MIN_VALUE : (int)this.pitch;
        return val;
    }

    public void setPitch(int pitch) {
        if (pitch == Integer.MIN_VALUE) {
            this.pitch = -2.147483648E9;
        } else {
            try {
                this.pitch = pitch < 0 ? 0.0 : ((double)pitch > 127.0 ? 127.0 : (double)pitch);
            }
            catch (RuntimeException re) {
                System.err.println("Error setting pitch value: You must enter pitch values between 0 and 127.0");
            }
        }
        this.pitchType = false;
    }

    public double getRhythmValue() {
        return this.rhythmValue;
    }

    public void setRhythmValue(double rhythmValue) {
        this.rhythmValue = rhythmValue < 0.0 ? 0.0 : (rhythmValue > Double.MAX_VALUE ? Double.MAX_VALUE : rhythmValue);
    }

    public int getDynamic() {
        return this.dynamic;
    }

    public void setDynamic(int dynamic) {
        this.dynamic = dynamic < 0 ? 0 : (dynamic > 127 ? 127 : dynamic);
    }

    public double getPan() {
        return this.pan;
    }

    public void setPan(double pan) {
        this.pan = pan < 0.0 ? 0.0 : (pan > Double.MAX_VALUE ? Double.MAX_VALUE : pan);
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration < 0.0 ? 0.0 : (duration > Double.MAX_VALUE ? Double.MAX_VALUE : duration);
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    public double getSampleStartTime() {
        return this.sampleStartTime;
    }

    public void setSampleStartTime(double sampleStartTime) {
        this.sampleStartTime = sampleStartTime;
    }

    public Phrase getMyPhrase() {
        return this.myPhrase;
    }

    public void setMyPhrase(Phrase phr) {
        this.myPhrase = phr;
    }

    public Note copy() {
        Note note = !this.pitchType ? new Note(this.getPitch(), this.rhythmValue, this.dynamic) : new Note(this.getFrequency(), this.rhythmValue, this.dynamic);
        note.setPan(this.pan);
        note.setDuration(this.duration);
        note.setOffset(this.offset);
        note.setSampleStartTime(this.sampleStartTime);
        note.setMyPhrase(this.myPhrase);
        for (int i = 0; i < this.breakPoints.length; ++i) {
            if (this.breakPoints[i] == null) continue;
            note.setBreakPoints(i, this.getBreakPoints(i));
        }
        return note;
    }

    public void setBreakPoints(int index, double[] points) {
        if (index < 0 || index > this.breakPoints.length) {
            System.err.println("jMusic Note error: BreakPoint index " + index + " is out of range when setting.");
            System.exit(1);
        }
        this.breakPoints[index] = points;
    }

    public double[] getBreakPoints(int index) {
        if (index < 0 || index > this.breakPoints.length) {
            System.err.println("jMusic Note error: BreakPoint index " + index + "is out of range when getting.");
            System.exit(1);
        }
        if (this.breakPoints[index] == null) {
            System.err.println("jMusic Note error: Breakpoint index " + index + " is empty.");
            System.exit(1);
        }
        return this.breakPoints[index];
    }

    public String toString() {
        String noteDetails = !this.pitchType ? new String("jMusic NOTE: [Pitch = " + (int)this.pitch + "][RhythmValue = " + this.rhythmValue + "][Dynamic = " + this.dynamic + "][Duration = " + this.duration + "][Pan = " + this.pan + "]") : new String("Note: [Frequency = " + this.pitch + "][RhythmValue = " + this.rhythmValue + "][Dynamic = " + this.dynamic + "][Duration = " + this.duration + "][Pan = " + this.pan + "]");
        return noteDetails;
    }

    public boolean isScale(int[] scale) {
        for (int j = 0; j < scale.length; ++j) {
            if (this.pitch % 12.0 != (double)scale[j]) continue;
            return true;
        }
        return false;
    }

    public void setRhythmValue(double rv, boolean factorDuration) {
        this.setRhythmValue(rv);
        if (factorDuration) {
            this.setDuration(rv * 0.9);
        }
    }

    public boolean isRest() {
        return this.getPitch() == Integer.MIN_VALUE;
    }

    public void setLength(double newLength) {
        this.setRhythmValue(newLength);
        this.setDuration(newLength * 0.9);
    }

    public boolean isSharp() {
        return this.getNote().equals(C_SHARP) || this.getNote().equals(F_SHARP);
    }

    public boolean isFlat() {
        return this.getNote().equals("Eb") || this.getNote().equals("Ab") || this.getNote().equals("Bb");
    }

    public boolean isNatural() {
        return !this.isSharp() && !this.isFlat();
    }

    public boolean samePitch(Note note) {
        return this.getPitch() == note.getPitch();
    }

    public boolean sameDuration(Note note) {
        return this.getDuration() == note.getDuration();
    }

    public boolean equals(Note note) {
        return this.samePitch(note) && this.sameDuration(note);
    }

    public Note nextNote(int[] scale) {
        Note nextNote = null;
        for (int i = 0; i < scale.length; ++i) {
            if (this.getPitchValue() % 12 != 0) continue;
            nextNote = new Note(this.getPitch() + scale[i], 1.0);
        }
        int nextpitch = this.getPitch() + scale[1];
        System.out.println("NEXT PITCH " + nextpitch + " " + this.getPitch() + " " + scale[1]);
        return new Note(nextpitch, 1.0);
    }

    public int getPitchValue() {
        int pitch = 0;
        if (this.noteString.equals(C)) {
            pitch = 60;
        } else if (this.noteString.equals(C_SHARP)) {
            pitch = 61;
        } else if (this.noteString.equals(D)) {
            pitch = 62;
        } else if (this.noteString.equals("Eb")) {
            pitch = 63;
        } else if (this.noteString.equals(E)) {
            pitch = 64;
        } else if (this.noteString.equals(F)) {
            pitch = 65;
        } else if (this.noteString.equals(F_SHARP)) {
            pitch = 66;
        } else if (this.noteString.equals(G)) {
            pitch = 67;
        } else if (this.noteString.equals("Ab")) {
            pitch = 68;
        } else if (this.noteString.equals(A)) {
            pitch = 69;
        } else if (this.noteString.equals("Bb")) {
            pitch = 70;
        } else if (this.noteString.equals(B)) {
            pitch = 71;
        }
        return pitch;
    }

    public String getNote() {
        this.noteString = this.getPitch() % 12 == 0 ? C : (this.getPitch() % 12 == 1 ? C_SHARP : (this.getPitch() % 12 == 2 ? D : (this.getPitch() % 12 == 3 ? "Eb" : (this.getPitch() % 12 == 4 ? E : (this.getPitch() % 12 == 5 ? F : (this.getPitch() % 12 == 6 ? F_SHARP : (this.getPitch() % 12 == 7 ? G : (this.getPitch() % 12 == 8 ? "Ab" : (this.getPitch() % 12 == 9 ? A : (this.getPitch() % 12 == 10 ? "Bb" : (this.getPitch() % 12 == 11 ? B : "N/A")))))))))));
        return this.noteString;
    }
}

