/*
 * Decompiled with CFR 0.152.
 */
package jm.music.data;

public class Tempo {
    public static double ANDANTE = 140.0;
    public static double DEFAULT_TEMPO = 60.0;
    private double value = DEFAULT_TEMPO;
    public static double DEFAULT_LOW = 1.0E-7;
    private double lowestTempo = DEFAULT_LOW;
    public static double DEFAULT_HIGH = 1000000.0;
    private double highestTempo = DEFAULT_HIGH;

    public Tempo() {
    }

    public Tempo(double initTempo) {
        this.value = initTempo;
    }

    public void setTempo(double newTempo) {
        this.value = this.setInBounds(newTempo);
    }

    private double setInBounds(double newTempo) {
        if (newTempo <= this.lowestTempo) {
            newTempo = this.lowestTempo;
        } else if (newTempo >= this.highestTempo) {
            newTempo = this.highestTempo;
        }
        return newTempo;
    }

    public double getPerMinute() {
        return this.value;
    }

    public double getPerSecond() {
        return 60.0 / this.value;
    }

    public double getHighestTempo() {
        return this.highestTempo;
    }

    public void setHighestTempo(double d) {
        this.highestTempo = d = this.checkBelowZero(d);
    }

    private double checkBelowZero(double d) {
        if (d < 0.0) {
            System.out.println("lowestTempo must be positive number!");
            System.out.println("setting it to 0.001");
            d = 0.001;
        }
        return d;
    }

    public double getLowestTempo() {
        return this.lowestTempo;
    }

    public void setLowestTempo(double d) {
        this.lowestTempo = d = this.checkBelowZero(d);
    }
}

