/*
 * Decompiled with CFR 0.152.
 */
package jm.music.rt;

import jm.audio.AOException;
import jm.audio.AudioChainListener;
import jm.audio.Instrument;
import jm.audio.RTMixer;
import jm.music.data.Note;

public abstract class RTLine
implements AudioChainListener {
    protected Instrument[] inst;
    protected boolean clear = false;
    Note note = null;
    double scorePos = 0.0;
    double temp = 1.0;
    private double localCounter = 0.0;
    private boolean newNote = true;
    private double tempo = 60.0;
    private double testPos;
    private double size;

    public RTLine(Instrument[] inst) {
        this.inst = inst;
        for (int i = 0; i < inst.length; ++i) {
            inst[i].addRTLine(this);
        }
        int sr = inst[0].getSampleRate();
        int ch = inst[0].getChannels();
        for (int i = 0; i < inst.length; ++i) {
            if (inst[i].getSampleRate() != sr) {
                System.err.println("jMusic RTLine error: All instruments must have the same sample rate.");
                System.exit(0);
            }
            if (inst[i].getChannels() == ch) continue;
            System.err.println("jMusic RTLine error: All instruments must have the same number of channels.");
            System.exit(0);
        }
        this.size = sr * ch;
    }

    public Instrument[] getInstrument() {
        return this.inst;
    }

    public int getNumLines() {
        return this.inst.length;
    }

    public void setTempo(double tempo) {
        this.tempo = tempo;
    }

    public void setBufferSize(int buf) {
        for (int i = 0; i < this.inst.length; ++i) {
            this.inst[i].setBufSize(buf);
        }
    }

    public int getSampleRate() {
        return this.inst[0].getSampleRate();
    }

    public int getChannels() {
        return this.inst[0].getChannels();
    }

    public void externalAction(Object obj, int actionNumber) {
    }

    public synchronized void controlChange(float[] buffer, int returned, boolean finished) {
    }

    public void instNote(Instrument inst, long samplesProcessed) {
        this.scorePos = (double)samplesProcessed / this.size;
        this.temp = 60.0 / this.tempo;
        if (this.scorePos > this.testPos) {
            this.note = this.getNextNote().copy();
            this.note.setRhythmValue(this.note.getRhythmValue() * this.temp);
            this.note.setDuration(this.note.getDuration() * this.temp);
            this.testPos += this.note.getRhythmValue();
        } else {
            this.note = new Note(Integer.MIN_VALUE, this.testPos - this.scorePos);
            this.note.setRhythmValue(this.note.getRhythmValue() * this.temp);
            this.note.setDuration(this.note.getRhythmValue());
        }
        inst.renderNote(this.note, this.scorePos);
    }

    public void start(RTMixer rta) {
        for (int i = 0; i < this.inst.length; ++i) {
            try {
                if (!this.inst[i].getInitialised()) {
                    this.inst[i].createChain();
                    this.inst[i].setInitialised(true);
                }
                this.inst[i].addAudioChainListener(rta);
                this.inst[i].start();
                continue;
            }
            catch (AOException aoe) {
                System.err.println("jMusic RTLine start error: Perhpas a jMusic instrument was being reused.");
                aoe.printStackTrace();
            }
        }
    }

    public void pause() {
        for (int i = 0; i < this.inst.length; ++i) {
            this.inst[i].pause();
        }
    }

    public void unPause() {
        for (int i = 0; i < this.inst.length; ++i) {
            this.inst[i].unPause();
        }
    }

    public void stop() {
        for (int i = 0; i < this.inst.length; ++i) {
            this.inst[i].stop();
        }
    }

    public abstract Note getNextNote();
}

