/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public final class AdaptiveMatrix {
    private int depth;
    private Hashtable weightMatrix;
    private Hashtable countMatrix;
    private int indexRange;

    public AdaptiveMatrix(int[] numArray, int depth, int indexRange) {
        this.countMatrix = new Hashtable();
        this.weightMatrix = new Hashtable();
        this.depth = depth;
        this.indexRange = indexRange;
        this.calcCount(numArray);
        this.calcWeight();
    }

    public AdaptiveMatrix(String fileName) {
        this.read(fileName);
    }

    public void update(int[] numArray) {
        this.calcCount(numArray);
        this.calcWeight();
    }

    public int[] generate(int length, int[] seed) {
        if (seed.length != this.depth) {
            System.err.println("[WARNING] Wrong seed length for this Matrix depth");
            return null;
        }
        int[] array = new int[length];
        String seedString = "";
        int[] seedbak = new int[seed.length];
        for (int i = 0; i < seed.length; ++i) {
            array[i] = seed[i];
            seedbak[i] = seed[i];
            seedString = seedString + seed[i] + " ";
        }
        String bak = seedString;
        if (!this.weightMatrix.containsKey(seedString)) {
            System.err.println("[WARNING] This seed is unavailable .. try another");
            return null;
        }
        block1: for (int i = seed.length; i < array.length; ++i) {
            if (!this.weightMatrix.containsKey(seedString)) {
                seedString = bak;
                seed = seedbak;
            }
            double[] tmp = (double[])this.weightMatrix.get(seedString);
            seedString = "";
            for (int k = 1; k < seed.length; ++k) {
                seedString = seedString + seed[k] + " ";
                seed[k - 1] = seed[k];
            }
            double rand = Math.random();
            double count = 0.0;
            for (int j = 0; j < tmp.length; ++j) {
                if (!((count += tmp[j]) > rand)) continue;
                array[i] = j;
                seedString = seedString + j + " ";
                seed[this.depth - 1] = j;
                continue block1;
            }
        }
        return array;
    }

    public void read(String fileName) {
        AdaptiveMatrix am = null;
        try {
            File file = new File(fileName);
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            am = (AdaptiveMatrix)ois.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.depth = am.getDepth();
        this.indexRange = am.getIndexRange();
        this.countMatrix = am.getCountMatrix();
        this.weightMatrix = am.getWeightMatrix();
    }

    public void write(String fileName) {
        try {
            File file = new File(fileName);
            FileOutputStream fis = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fis);
            oos.writeObject(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void print() {
        System.out.println();
        System.out.println("MATRIX");
        System.out.println("----------------");
        Enumeration enum1 = this.weightMatrix.keys();
        while (enum1.hasMoreElements()) {
            String prefix = (String)enum1.nextElement();
            double[] postfix = (double[])this.weightMatrix.get(prefix);
            System.out.print(prefix + "\t: ");
            for (int i = 0; i < postfix.length; ++i) {
                System.out.print(" " + postfix[i]);
            }
            System.out.println();
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public Hashtable getWeightMatrix() {
        return this.weightMatrix;
    }

    public Hashtable getCountMatrix() {
        return this.countMatrix;
    }

    public int getIndexRange() {
        return this.indexRange;
    }

    private void calcCount(int[] numArray) {
        for (int i = this.depth - 1; i < numArray.length - 1; ++i) {
            String prefix = "";
            int[] post = new int[this.indexRange];
            int j = 0;
            int k = this.depth - 1;
            while (j < this.depth) {
                prefix = prefix + numArray[i - k] + " ";
                ++j;
                --k;
            }
            if (this.countMatrix.containsKey(prefix)) {
                int[] postfix = (int[])this.countMatrix.get(prefix);
                int n = numArray[i + 1];
                postfix[n] = postfix[n] + 1;
                this.countMatrix.put(prefix, postfix);
                continue;
            }
            int n = numArray[i + 1];
            post[n] = post[n] + 1;
            this.countMatrix.put(prefix, post);
        }
    }

    private void calcWeight() {
        Enumeration enum1 = this.countMatrix.keys();
        while (enum1.hasMoreElements()) {
            String prefix = (String)enum1.nextElement();
            int[] postfix = (int[])this.countMatrix.get(prefix);
            int count = 0;
            for (int i = 0; i < postfix.length; ++i) {
                count += postfix[i];
            }
            double[] postfix2 = new double[this.indexRange];
            for (int i = 0; i < postfix.length; ++i) {
                postfix2[i] = (double)postfix[i] / (double)count;
            }
            this.weightMatrix.put(prefix, postfix2);
        }
    }
}

