/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools;

import jm.JMC;
import jm.music.data.Note;
import jm.music.data.Phrase;
import jm.music.tools.AdaptiveMatrix;

public final class PhraseMatrix
implements JMC {
    private final double[] rhythmMap = new double[]{4.0, 3.0, 2.0, 1.0, 0.6666666666666666, 1.5, 0.5, 0.75, 0.3333333333333333, 0.25, 0.125};
    private AdaptiveMatrix pitchAM;
    private AdaptiveMatrix rhythmAM;
    private AdaptiveMatrix dynamicAM;
    private int pitchDepth;
    private int rhythmDepth;
    private int dynamicDepth;
    private Note[] notes;

    public PhraseMatrix(Phrase phrase, int depth) {
        this(phrase, depth, depth, depth);
    }

    public PhraseMatrix(Phrase phrase, int pDepth, int rDepth, int dDepth) {
        this.pitchDepth = pDepth;
        this.rhythmDepth = rDepth;
        this.dynamicDepth = dDepth;
        this.notes = phrase.getNoteArray();
        this.calcPitch();
        this.calcRhythm();
        this.calcDynamic();
    }

    public void calcPitch() {
        int[] numArray = new int[this.notes.length];
        for (int i = 0; i < this.notes.length; ++i) {
            numArray[i] = this.notes[i].getPitch();
        }
        this.pitchAM = new AdaptiveMatrix(numArray, this.pitchDepth, 127);
    }

    public void calcRhythm() {
        int[] numArray = new int[this.notes.length];
        for (int i = 0; i < this.notes.length; ++i) {
            boolean flag = false;
            for (int j = 0; j < this.rhythmMap.length; ++j) {
                if (this.notes[i].getRhythmValue() != this.rhythmMap[j]) continue;
                flag = true;
                numArray[i] = j;
                break;
            }
            if (flag) continue;
            System.err.print("[WARNING] PhraseMatrix only supports ");
            System.err.println("rhythm values supported in the JMC file");
        }
        this.rhythmAM = new AdaptiveMatrix(numArray, this.rhythmDepth, this.rhythmMap.length);
    }

    public void calcDynamic() {
        int[] numArray = new int[this.notes.length];
        for (int i = 0; i < this.notes.length; ++i) {
            numArray[i] = this.notes[i].getDynamic();
        }
        this.dynamicAM = new AdaptiveMatrix(numArray, this.dynamicDepth, 127);
    }

    public Phrase generate(boolean p, boolean r, boolean d) {
        return this.generate(p, r, d, this.notes.length);
    }

    public Phrase generate(boolean p, boolean r, boolean d, int numOfNotes) {
        int i;
        int i2;
        int[] pitch = new int[this.pitchDepth];
        int[] rhythm = new int[this.rhythmDepth];
        int[] dynamic = new int[this.dynamicDepth];
        Note[] noteList = new Note[numOfNotes];
        for (i2 = 0; i2 < numOfNotes; ++i2) {
            noteList[i2] = new Note();
        }
        for (i2 = 0; i2 < this.pitchDepth; ++i2) {
            pitch[i2] = this.notes[i2].getPitch();
        }
        block2: for (i2 = 0; i2 < this.rhythmDepth; ++i2) {
            for (int j = 0; j < this.rhythmMap.length; ++j) {
                if (this.notes[i2].getRhythmValue() != this.rhythmMap[j]) continue;
                rhythm[i2] = j;
                continue block2;
            }
        }
        for (i2 = 0; i2 < this.dynamicDepth; ++i2) {
            dynamic[i2] = this.notes[i2].getDynamic();
        }
        int[] retPitch = this.pitchAM.generate(numOfNotes, pitch);
        int[] retDynamic = this.dynamicAM.generate(numOfNotes, dynamic);
        int[] retRhythm = this.rhythmAM.generate(numOfNotes, rhythm);
        if (p) {
            for (i = 0; i < numOfNotes; ++i) {
                noteList[i].setPitch(retPitch[i]);
            }
        }
        if (r) {
            for (i = 0; i < numOfNotes; ++i) {
                noteList[i].setRhythmValue(this.rhythmMap[retRhythm[i]]);
                noteList[i].setDuration(this.rhythmMap[retRhythm[i]] * 0.9);
            }
        }
        if (d) {
            for (i = 0; i < numOfNotes; ++i) {
                noteList[i].setDynamic(retDynamic[i]);
            }
        }
        Phrase phrase = new Phrase();
        phrase.addNoteList(noteList);
        return phrase;
    }
}

