/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools.ca;

public class CellularAutomata {
    int xSize;
    int ySize;
    boolean wrapAround;
    boolean[][] cellStates;
    int[][] cellSurrounds;

    public CellularAutomata(int xSize, int ySize) {
        this(xSize, ySize, 25, false);
    }

    public CellularAutomata(int xSize, int ySize, int seed) {
        this(xSize, ySize, seed, false);
    }

    public CellularAutomata(int xSize, int ySize, int seed, boolean wrapAround) {
        this.xSize = xSize;
        this.ySize = ySize;
        this.wrapAround = wrapAround;
        this.cellStates = new boolean[xSize][ySize];
        this.cellSurrounds = new int[xSize][ySize];
        this.setGrid(seed);
    }

    public void evolve() {
        boolean[][] nextCellStates = new boolean[this.xSize][this.ySize];
        for (int i = 0; i < this.xSize; ++i) {
            for (int j = 0; j < this.ySize; ++j) {
                if (this.getState(i, j)) {
                    if (this.getSurrounding(i, j) == 2) {
                        nextCellStates[i][j] = true;
                        continue;
                    }
                    nextCellStates[i][j] = false;
                    continue;
                }
                if (this.getState(i, j) || this.getSurrounding(i, j) != 2 && this.getSurrounding(i, j) != 3) continue;
                nextCellStates[i][j] = true;
            }
        }
        this.cellStates = nextCellStates;
    }

    public boolean getState(int xPos, int yPos) {
        return this.cellStates[xPos][yPos];
    }

    public boolean[][] getAllStates() {
        return this.cellStates;
    }

    public int getSurrounding(int xPos, int yPos) {
        int counter;
        block47: {
            block46: {
                block45: {
                    block44: {
                        block43: {
                            block42: {
                                block41: {
                                    block40: {
                                        counter = 0;
                                        try {
                                            if (this.cellStates[xPos - 1][yPos - 1]) {
                                                ++counter;
                                            }
                                        }
                                        catch (ArrayIndexOutOfBoundsException e) {
                                            if (!this.wrapAround) break block40;
                                            if (xPos - 1 < 0 && yPos - 1 < 0) {
                                                if (this.cellStates[this.xSize - 1][this.ySize - 1]) {
                                                    ++counter;
                                                }
                                            }
                                            if (xPos - 1 < 0) {
                                                if (this.cellStates[this.xSize - 1][yPos - 1]) {
                                                    ++counter;
                                                }
                                            }
                                            if (yPos - 1 >= 0 || !this.cellStates[xPos - 1][this.ySize - 1]) break block40;
                                            ++counter;
                                        }
                                    }
                                    try {
                                        if (this.cellStates[xPos][yPos - 1]) {
                                            ++counter;
                                        }
                                    }
                                    catch (ArrayIndexOutOfBoundsException e) {
                                        if (!this.wrapAround || !this.cellStates[xPos][this.ySize - 1]) break block41;
                                        ++counter;
                                    }
                                }
                                try {
                                    if (this.cellStates[xPos + 1][yPos - 1]) {
                                        ++counter;
                                    }
                                }
                                catch (ArrayIndexOutOfBoundsException e) {
                                    if (!this.wrapAround) break block42;
                                    if (xPos + 1 >= this.xSize && yPos - 1 < 0) {
                                        if (this.cellStates[0][this.ySize - 1]) {
                                            ++counter;
                                        }
                                    }
                                    if (xPos + 1 >= this.xSize) {
                                        if (this.cellStates[0][yPos - 1]) {
                                            ++counter;
                                        }
                                    }
                                    if (yPos - 1 >= 0 || !this.cellStates[xPos + 1][this.ySize - 1]) break block42;
                                    ++counter;
                                }
                            }
                            try {
                                if (this.cellStates[xPos - 1][yPos]) {
                                    ++counter;
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                if (!this.wrapAround || !this.cellStates[this.xSize - 1][yPos]) break block43;
                                ++counter;
                            }
                        }
                        try {
                            if (this.cellStates[xPos + 1][yPos]) {
                                ++counter;
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            if (!this.wrapAround || !this.cellStates[0][yPos]) break block44;
                            ++counter;
                        }
                    }
                    try {
                        if (this.cellStates[xPos - 1][yPos + 1]) {
                            ++counter;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        if (!this.wrapAround) break block45;
                        if (xPos - 1 < 0 && yPos + 1 >= this.ySize) {
                            if (this.cellStates[this.xSize - 1][0]) {
                                ++counter;
                            }
                        }
                        if (xPos - 1 < 0) {
                            if (this.cellStates[this.xSize - 1][yPos + 1]) {
                                ++counter;
                            }
                        }
                        if (yPos + 1 < this.ySize || !this.cellStates[xPos - 1][0]) break block45;
                        ++counter;
                    }
                }
                try {
                    if (this.cellStates[xPos][yPos + 1]) {
                        ++counter;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    if (!this.wrapAround || !this.cellStates[xPos][0]) break block46;
                    ++counter;
                }
            }
            try {
                if (this.cellStates[xPos + 1][yPos + 1]) {
                    ++counter;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (!this.wrapAround) break block47;
                if (xPos + 1 >= this.xSize && yPos + 1 >= this.ySize) {
                    if (this.cellStates[0][0]) {
                        ++counter;
                    }
                }
                if (xPos + 1 >= this.xSize) {
                    if (this.cellStates[0][yPos + 1]) {
                        ++counter;
                    }
                }
                if (yPos + 1 < this.ySize || !this.cellStates[xPos + 1][0]) break block47;
                ++counter;
            }
        }
        return counter;
    }

    public void print() {
        for (int i = 0; i < this.xSize; ++i) {
            for (int j = 0; j < this.ySize; ++j) {
                if (this.getState(i, j)) {
                    System.out.print("1");
                    continue;
                }
                System.out.print("0");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    public void setGrid(int seed) {
        for (int i = 0; i < this.xSize; ++i) {
            for (int j = 0; j < this.ySize; ++j) {
                this.cellStates[i][j] = this.trueFalse(seed);
            }
        }
    }

    private boolean trueFalse(int seed) {
        int randNum = (int)(Math.random() * 100.0);
        boolean choice = randNum < seed;
        return choice;
    }
}

