/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools.fuzzy;

public class FuzzyNumber {
    private double peak;
    private double min;
    private double max;
    private double diff;
    private double membership;

    public FuzzyNumber(double peak, double min, double max) {
        this.peak = peak;
        this.min = min;
        this.max = max;
    }

    public double getMembership(double value) {
        if (value < this.min || value > this.max) {
            return 0.0;
        }
        this.diff = this.peak - value;
        this.membership = this.diff >= 0.0 ? 1.0 - this.diff / (this.peak - this.min) : 1.0 + this.diff / (this.max - this.peak);
        return this.membership;
    }

    public double getPeak() {
        return this.peak;
    }

    public void setPeak(double newValue) {
        this.peak = newValue;
        if (this.min > newValue) {
            this.min = newValue;
        }
        if (this.max < newValue) {
            this.max = newValue;
        }
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double newValue) {
        this.min = newValue;
        if (this.peak < newValue) {
            this.peak = newValue;
        }
        if (this.max < newValue) {
            this.max = newValue;
        }
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double newValue) {
        this.max = newValue;
        if (this.min > newValue) {
            this.min = newValue;
        }
        if (this.peak > newValue) {
            this.peak = newValue;
        }
    }
}

