/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools.ga;

import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import jm.music.data.Note;
import jm.music.data.Phrase;
import jm.music.tools.PhraseAnalysis;
import jm.music.tools.ga.PopulationInitialiser;

public class ClimaticPopInitialiser
extends PopulationInitialiser {
    public static final int MIN_POPULATION_SIZE = 2;
    public static final int MAX_POPULATION_SIZE = 100;
    public static final int DEFAULT_POPULATION_SIZE = 50;
    public static final double CLIMAX_AVERAGE = 0.523;
    public static final double CLIMAX_ST_DEV = 0.261;
    protected static String label = "Climatic Population Initialiser";
    public final int TONIC = 60;
    protected Panel panel;
    protected int populationSize;
    protected Label populationLabel;
    protected boolean modifyAll = false;

    public ClimaticPopInitialiser() {
        this(50);
    }

    public ClimaticPopInitialiser(int population) {
        this.populationSize = population;
        this.panel = new Panel();
        this.panel.setLayout(new FlowLayout(0, 0, 0));
        this.populationLabel = new Label(Integer.toString(this.populationSize));
        this.panel.add(new Label("Population Size", 2));
        this.panel.add(new Scrollbar(0, this.populationSize, 1, 2, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    public void adjustmentValueChanged(AdjustmentEvent evt) {
                        ClimaticPopInitialiser.this.populationSize = this.getValue();
                        ClimaticPopInitialiser.this.populationLabel.setText(Integer.toString(this.getValue()));
                        ClimaticPopInitialiser.this.populationLabel.repaint();
                    }
                });
            }
        });
        this.panel.add(this.populationLabel);
    }

    public Phrase[] initPopulation(Phrase phrase, int beatsPerBar) {
        Phrase seed = this.completeFinalBeat(phrase, beatsPerBar);
        int size = this.modifyAll ? 0 : seed.size();
        double[][] beatRhythmArray = this.generateBeatRhythmArray(seed, beatsPerBar);
        int[] intervalArray = this.generateIntervalArray(seed);
        Phrase[] population = new Phrase[this.populationSize];
        for (int i = 0; i < this.populationSize; ++i) {
            int j;
            int targetBeat;
            Note target;
            population[i] = seed.copy();
            int climax = 0;
            if (this.isClimaxAccepted(seed, beatsPerBar)) {
                climax = this.findClimax(seed);
                target = new Note(60, (double)beatsPerBar);
                targetBeat = 7 * beatsPerBar;
            } else {
                int lowestPitch = 127;
                for (j = 0; j < seed.size(); ++j) {
                    int currentPitch = seed.getNote(j).getPitch();
                    if (currentPitch == Integer.MIN_VALUE || currentPitch >= lowestPitch) continue;
                    lowestPitch = currentPitch;
                }
                target = this.generateClimax(lowestPitch);
                climax = target.getPitch();
                targetBeat = 4 * beatsPerBar;
            }
            int lowerlimit = -1;
            for (j = 0; j < seed.size(); ++j) {
                int pitch = seed.getNote(j).getPitch();
                if (pitch == Integer.MIN_VALUE) continue;
                lowerlimit = pitch - 12;
                break;
            }
            if (lowerlimit < 53) {
                lowerlimit = 53;
            }
            this.extend(population[i], target, targetBeat, beatRhythmArray, intervalArray, climax, beatsPerBar, lowerlimit);
            this.addAppropriateTarget(population[i], target);
            if (population[i].getEndTime() != (double)(8 * beatsPerBar)) {
                target = new Note(60, (double)beatsPerBar);
                targetBeat = 7 * beatsPerBar;
                this.extend(population[i], target, targetBeat, beatRhythmArray, intervalArray, climax, beatsPerBar, lowerlimit);
                int noteIndex = population[i].size() - 1;
                int previousPitch = population[i].getNote(noteIndex).getPitch();
                while (previousPitch == Integer.MIN_VALUE) {
                    previousPitch = population[i].getNote(--noteIndex).getPitch();
                }
                int targetPitch = target.getPitch();
                if (previousPitch < targetPitch) {
                    if (targetPitch - previousPitch > 6) {
                        target.setPitch(targetPitch - 12);
                    }
                } else if (previousPitch > targetPitch && previousPitch - targetPitch > 6) {
                    target.setPitch(targetPitch + 12);
                }
                population[i].addNote(target);
            }
            this.cleanMelody(population[i], size);
        }
        return population;
    }

    private Phrase completeFinalBeat(Phrase phrase, int beatsPerBar) {
        Phrase returnPhrase = phrase.copy();
        double length = returnPhrase.getEndTime();
        double rhythmValueToCompleteBeat = Math.ceil(length) - length;
        if (rhythmValueToCompleteBeat > 0.0) {
            int[] intervals = this.generateIntervalArray(phrase);
            int counter = returnPhrase.size() - 1;
            int pitch = Integer.MIN_VALUE;
            while (pitch == Integer.MIN_VALUE) {
                pitch = returnPhrase.getNote(counter--).getPitch();
            }
            if (!this.isScale(pitch += intervals[(int)(Math.random() * (double)intervals.length)])) {
                pitch = Math.random() < 0.5 ? ++pitch : --pitch;
            }
            returnPhrase.addNote(new Note(pitch, rhythmValueToCompleteBeat));
        }
        return returnPhrase;
    }

    private double[][] generateBeatRhythmArray(Phrase phrase, int beatsPerBar) {
        double[][] tempBeatRVArray = new double[(int)phrase.getEndTime() * beatsPerBar][];
        int beatCount = 0;
        int absoluteNotesProcessed = 0;
        double absoluteCumulativeRV = 0.0;
        while (absoluteNotesProcessed < phrase.size()) {
            int originalNotesProcessed = absoluteNotesProcessed;
            double originalCumulativeRV = absoluteCumulativeRV;
            int notesProcessed = absoluteNotesProcessed;
            double cumulativeRV = absoluteCumulativeRV;
            double[] tempRVArray = new double[phrase.size()];
            int count = 0;
            Note note = phrase.getNote(notesProcessed++);
            double rhythmValue = note.getRhythmValue();
            tempRVArray[count++] = rhythmValue;
            if (note.getPitch() == Integer.MIN_VALUE) {
                int n = count - 1;
                tempRVArray[n] = tempRVArray[n] * -1.0;
            }
            cumulativeRV += rhythmValue;
            while (cumulativeRV != Math.ceil(cumulativeRV)) {
                note = phrase.getNote(notesProcessed++);
                rhythmValue = note.getRhythmValue();
                tempRVArray[count++] = rhythmValue;
                if (note.getPitch() == Integer.MIN_VALUE) {
                    int n = count - 1;
                    tempRVArray[n] = tempRVArray[n] * -1.0;
                }
                cumulativeRV += rhythmValue;
            }
            double[] RVArray = new double[count];
            System.arraycopy(tempRVArray, 0, RVArray, 0, count);
            tempBeatRVArray[beatCount++] = RVArray;
            absoluteNotesProcessed = notesProcessed;
            absoluteCumulativeRV = cumulativeRV;
            while (cumulativeRV < originalCumulativeRV + (double)beatsPerBar && notesProcessed < phrase.size()) {
                note = phrase.getNote(notesProcessed++);
                rhythmValue = note.getRhythmValue();
                tempRVArray[count++] = rhythmValue;
                if (note.getPitch() == Integer.MIN_VALUE) {
                    int n = count - 1;
                    tempRVArray[n] = tempRVArray[n] * -1.0;
                }
                cumulativeRV += rhythmValue;
                while (cumulativeRV != Math.ceil(cumulativeRV)) {
                    note = phrase.getNote(notesProcessed++);
                    rhythmValue = note.getRhythmValue();
                    tempRVArray[count++] = rhythmValue;
                    if (note.getPitch() == Integer.MIN_VALUE) {
                        int n = count - 1;
                        tempRVArray[n] = tempRVArray[n] * -1.0;
                    }
                    cumulativeRV += rhythmValue;
                }
                if (!(cumulativeRV <= originalCumulativeRV + (double)beatsPerBar)) continue;
                RVArray = new double[count];
                System.arraycopy(tempRVArray, 0, RVArray, 0, count);
                tempBeatRVArray[beatCount++] = RVArray;
            }
        }
        double[][] beatRVArray = new double[beatCount][];
        System.arraycopy(tempBeatRVArray, 0, beatRVArray, 0, beatCount);
        return beatRVArray;
    }

    private int[] generateIntervalArray(Phrase phrase) {
        int[] intervals = new int[]{};
        try {
            intervals = PhraseAnalysis.pitchIntervals(phrase);
        }
        catch (ArrayStoreException e) {
            System.exit(0);
        }
        int[] tempIntervalArray = new int[intervals.length * 2];
        System.arraycopy(intervals, 0, tempIntervalArray, 0, intervals.length);
        for (int i = 0; i < intervals.length; ++i) {
            if (tempIntervalArray[i] > 127) {
                int n = i;
                tempIntervalArray[n] = tempIntervalArray[n] - 255;
            }
            tempIntervalArray[intervals.length + i] = 0 - tempIntervalArray[i];
        }
        return tempIntervalArray;
    }

    private boolean isClimaxAccepted(Phrase phrase, int beatsPerBar) {
        int lastHighestPitch = 0;
        int repetitions = 0;
        double cumulativeRV = 0.0;
        double location = 0.0;
        for (int i = 0; i < phrase.size(); ++i) {
            int pitch = phrase.getNote(i).getPitch();
            if (pitch != Integer.MIN_VALUE) {
                if (pitch > lastHighestPitch) {
                    lastHighestPitch = pitch;
                    location = cumulativeRV;
                    repetitions = 0;
                } else if (pitch == lastHighestPitch) {
                    ++repetitions;
                    location = cumulativeRV;
                }
            }
            cumulativeRV += phrase.getNote(i).getRhythmValue();
        }
        if (location < (double)(8 * beatsPerBar) * 0.262 || location > (double)(8 * beatsPerBar) * 0.784) {
            return false;
        }
        return lastHighestPitch > phrase.getNote(0).getPitch() + 12 && repetitions <= 1;
    }

    private int findClimax(Phrase phrase) {
        int lastHighestPitch = 0;
        for (int i = 0; i < phrase.size(); ++i) {
            int pitch = phrase.getNote(i).getPitch();
            if (pitch == Integer.MIN_VALUE || pitch <= lastHighestPitch) continue;
            lastHighestPitch = pitch;
        }
        return lastHighestPitch;
    }

    private Note generateClimax(int lowestPitch) {
        int pitch = 0;
        int currentPitch = lowestPitch + 13;
        while (pitch == 0) {
            if (currentPitch % 12 == 0 || currentPitch % 12 == 7) {
                pitch = currentPitch;
            }
            ++currentPitch;
        }
        while (pitch > 88) {
            if (currentPitch % 12 == 0 || currentPitch % 12 == 7) {
                pitch = currentPitch;
            }
            --currentPitch;
        }
        return new Note(pitch, 1.0);
    }

    private void extend(Phrase phrase, Note target, int targetBeat, double[][] beatArray, int[] intervalArray, int climax, int beatsPerBar, int lowerlimit) {
        int length = (int)phrase.getEndTime();
        while (length < targetBeat) {
            if (length == 2 * beatsPerBar) {
                int noteIndex = phrase.size() - 1;
                int previousPitch = phrase.getNote(noteIndex).getPitch();
                while (previousPitch == Integer.MIN_VALUE) {
                    previousPitch = phrase.getNote(--noteIndex).getPitch();
                }
                if (previousPitch % 12 != 0 && previousPitch % 12 != 7) {
                    int nextHarmoniousNote = previousPitch + 1;
                    while (nextHarmoniousNote % 12 != 0 && nextHarmoniousNote % 12 != 7) {
                        ++nextHarmoniousNote;
                    }
                    int prevHarmoniousNote = previousPitch - 1;
                    while (prevHarmoniousNote % 12 != 0 && prevHarmoniousNote % 12 != 7) {
                        --prevHarmoniousNote;
                    }
                    previousPitch = nextHarmoniousNote > climax ? prevHarmoniousNote : (prevHarmoniousNote < lowerlimit ? nextHarmoniousNote : (nextHarmoniousNote - previousPitch > previousPitch - prevHarmoniousNote ? prevHarmoniousNote : (previousPitch - prevHarmoniousNote > nextHarmoniousNote - previousPitch ? nextHarmoniousNote : nextHarmoniousNote)));
                }
                phrase.addNote(new Note(previousPitch, 2.0));
            } else {
                int counter;
                int beatsInArray = targetBeat;
                int beatIndex = 0;
                for (counter = 0; counter < 30 && length + beatsInArray > (length / beatsPerBar + 1) * beatsPerBar; ++counter) {
                    beatIndex = (int)(Math.random() * (double)beatArray.length);
                    double tempRVCount = 0.0;
                    for (int i = 0; i < beatArray[beatIndex].length; ++i) {
                        tempRVCount += beatArray[beatIndex][i] < 0.0 ? 0.0 - beatArray[beatIndex][i] : beatArray[beatIndex][i];
                    }
                    beatsInArray = (int)tempRVCount;
                }
                if (counter != 30) {
                    for (int i = 0; i < beatArray[beatIndex].length; ++i) {
                        this.addNote(phrase, target, targetBeat, beatArray[beatIndex][i], intervalArray, climax, lowerlimit);
                    }
                } else {
                    this.addNote(phrase, target, targetBeat, (length / beatsPerBar + 1) * beatsPerBar - length, intervalArray, climax, lowerlimit);
                }
            }
            length = (int)phrase.getEndTime();
        }
    }

    private void addAppropriateTarget(Phrase phrase, Note target) {
        int lastPitch;
        Note targetToAdd = target.copy();
        int lastIndex = phrase.size();
        while ((lastPitch = phrase.getNote(--lastIndex).getPitch()) == Integer.MIN_VALUE) {
        }
        int targetPitch = target.getPitch();
        if (lastPitch + 7 < targetPitch) {
            while ((targetPitch -= 12) - 12 > lastPitch) {
            }
            targetToAdd.setPitch(targetPitch);
        }
        phrase.addNote(targetToAdd);
    }

    private void addNote(Phrase phrase, Note target, int targetBeat, double rhythmValue, int[] intervalArray, int climax, int lowerlimit) {
        if (rhythmValue < 0.0) {
            phrase.addNote(new Note(Integer.MIN_VALUE, 0.0 - rhythmValue));
        } else {
            int pitch;
            double currentRatio;
            double ratioOfRatios;
            int currentInterval;
            int noteIndex = phrase.size() - 1;
            int previousPitch = phrase.getNote(noteIndex).getPitch();
            while (previousPitch == Integer.MIN_VALUE) {
                previousPitch = phrase.getNote(--noteIndex).getPitch();
            }
            double originalRatio = (double)(target.getPitch() - previousPitch) / ((double)targetBeat - phrase.getEndTime());
            int selectedInterval = intervalArray[(int)(Math.random() * (double)intervalArray.length)];
            double intervalRatio = (double)selectedInterval / (double)(currentInterval = target.getPitch() - previousPitch);
            if (intervalRatio < 0.0 && Math.random() < 2.5 / ((double)targetBeat - phrase.getEndTime())) {
                selectedInterval = 0 - selectedInterval;
            }
            if ((ratioOfRatios = (currentRatio = (double)currentInterval / ((double)targetBeat - phrase.getEndTime())) / originalRatio) >= 2.0 || ratioOfRatios <= 0.5) {
                selectedInterval /= 2;
            }
            if ((pitch = previousPitch + selectedInterval) >= climax || pitch < lowerlimit) {
                pitch = previousPitch - selectedInterval;
            }
            if (pitch >= climax || pitch < lowerlimit) {
                pitch = previousPitch - selectedInterval / 2;
            }
            if (pitch >= climax || pitch < lowerlimit) {
                pitch = previousPitch - selectedInterval / 4;
            }
            phrase.addNote(new Note(pitch, rhythmValue));
        }
    }

    private void cleanMelody(Phrase phrase, int size) {
        for (int i = size; i < phrase.size(); ++i) {
            int pitch = phrase.getNote(i).getPitch();
            if (pitch == Integer.MIN_VALUE || this.isScale(pitch)) continue;
            if (Math.random() < 0.5) {
                phrase.getNote(i).setPitch(pitch + 1);
                continue;
            }
            phrase.getNote(i).setPitch(pitch - 1);
        }
    }

    private boolean isScale(int pitch) {
        for (int j = 0; j < PhraseAnalysis.MAJOR_SCALE.length; ++j) {
            if (pitch % 12 != PhraseAnalysis.MAJOR_SCALE[j]) continue;
            return true;
        }
        return false;
    }

    public Panel getPanel() {
        return this.panel;
    }

    public String getLabel() {
        return label;
    }

    public void setModifyAll(boolean val) {
        this.modifyAll = val;
    }
}

