/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools.ga;

import java.awt.Choice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import jm.music.data.Note;
import jm.music.data.Phrase;
import jm.music.tools.PhraseAnalysis;
import jm.music.tools.ga.Mutater;

public class ComplexMutater
extends Mutater {
    private static final int SEMITONES_PER_OCTAVE = 12;
    private static final int TONIC = 60;
    protected static String label = "Mutater";
    protected Panel panel;
    protected Choice choice;
    protected Scrollbar scrollbar;
    protected Label mutateLabel;
    protected boolean modifyAll = false;
    private int[] MUTATE_PERCENTAGE = new int[]{0, 40, 1, 40, 60};

    public ComplexMutater() {
        this.panel = new Panel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.panel.setLayout(gbl);
        this.mutateLabel = new Label(Integer.toString(this.MUTATE_PERCENTAGE[0]));
        this.scrollbar = new Scrollbar(0, this.MUTATE_PERCENTAGE[0], 1, 0, 100);
        this.choice = new Choice();
        this.choice.add("Random pitch change");
        this.choice.add("Bar sequence mutations");
        this.choice.add("Split and merge");
        this.choice.add("Step interpolation");
        this.choice.add("Tonal Pauses");
        this.choice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ComplexMutater.this.mutateLabel.setText(Integer.toString(ComplexMutater.this.MUTATE_PERCENTAGE[ComplexMutater.this.choice.getSelectedIndex()]));
                ComplexMutater.this.scrollbar.setValue(ComplexMutater.this.MUTATE_PERCENTAGE[ComplexMutater.this.choice.getSelectedIndex()]);
            }
        });
        this.scrollbar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent evt) {
                ((ComplexMutater)ComplexMutater.this).MUTATE_PERCENTAGE[ComplexMutater.this.choice.getSelectedIndex()] = ComplexMutater.this.scrollbar.getValue();
                ComplexMutater.this.mutateLabel.setText(Integer.toString(ComplexMutater.this.scrollbar.getValue()));
                ComplexMutater.this.mutateLabel.repaint();
            }
        });
        gbc.gridy = -1;
        gbc.gridwidth = 2;
        gbl.setConstraints(this.choice, gbc);
        this.panel.add(this.choice);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbl.setConstraints(this.scrollbar, gbc);
        this.panel.add(this.scrollbar);
        gbc.gridx = -1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbl.setConstraints(this.mutateLabel, gbc);
        this.panel.add(this.mutateLabel);
    }

    private static int pitchToDegree(int pitch, int tonic) {
        if ((pitch -= tonic) < 0) {
            pitch += (-pitch / 12 + 1) * 12;
        }
        return pitch % 12;
    }

    public Phrase[] mutate(Phrase[] population, double initialLength, int initialSize, int beatsPerBar) {
        int i;
        double[] mutationArray = new double[population.length];
        for (i = 0; i < population.length; ++i) {
            mutationArray[i] = population[i].getEndTime();
        }
        for (i = 0; i < population.length; ++i) {
            Phrase individual = population[i];
            if (this.modifyAll) {
                initialSize = 0;
                initialLength = 0.0;
            }
            int n = individual.size() - initialSize;
            double n2change1 = (double)(n * this.MUTATE_PERCENTAGE[0]) / 100.0;
            int n2change = 0;
            n2change = n2change1 < 1.0 ? (Math.random() < n2change1 ? 1 : 0) : (int)Math.floor(n2change1);
            for (int j = 0; j < n2change; ++j) {
                int r = (int)(Math.random() * (double)n);
                this.mutate(individual.getNote(initialSize + r));
            }
            if (Math.random() < (double)this.MUTATE_PERCENTAGE[1] / 100.0) {
                boolean previousNoteOnBar = false;
                double beatCount = 0.0;
                for (int j = 0; j < individual.size(); ++j) {
                    beatCount += individual.getNote(j).getRhythmValue();
                }
                int[] notesOnBars = new int[(int)beatCount];
                int[] barNumber = new int[(int)beatCount];
                int index = 0;
                beatCount = 0.0;
                for (int j = 0; j < individual.size(); ++j) {
                    if (beatCount / (double)beatsPerBar == Math.floor(beatCount / (double)beatsPerBar)) {
                        notesOnBars[index] = j;
                        barNumber[index++] = (int)(beatCount * (double)beatsPerBar);
                    }
                    beatCount += individual.getNote(j).getRhythmValue();
                }
                int countOfEncapsulatedBars = 0;
                int[] notesBeginningEncapsulatedBars = new int[index];
                if (index > 0) {
                    for (int j = 1; j < index; ++j) {
                        if (barNumber[j] != barNumber[j - 1] + 1) continue;
                        notesBeginningEncapsulatedBars[countOfEncapsulatedBars++] = notesOnBars[j - 1];
                    }
                }
                if (countOfEncapsulatedBars > 0) {
                    int r2 = 0;
                    while (r2 < (int)(initialLength / (double)beatsPerBar) - 1) {
                        r2 = (int)(Math.random() * (double)countOfEncapsulatedBars);
                    }
                    int r3 = (int)(Math.random() * 2.0 + 1.0);
                    switch (r3) {
                        case 1: {
                            int transpose = 0;
                            transpose = Math.random() < 0.5 ? 2 : -2;
                            index = notesBeginningEncapsulatedBars[r2];
                            for (beatCount = 0.0; beatCount < (double)beatsPerBar; beatCount += individual.getNote(index++).getRhythmValue()) {
                                this.shiftPitch(individual.getNote(index), transpose);
                            }
                            break;
                        }
                        default: {
                            int j;
                            index = notesBeginningEncapsulatedBars[r2];
                            for (beatCount = 0.0; beatCount < (double)beatsPerBar; beatCount += individual.getNote(index++).getRhythmValue()) {
                            }
                            int notesInBar = index - notesBeginningEncapsulatedBars[r2];
                            index = notesBeginningEncapsulatedBars[r2];
                            if (notesInBar <= 0) break;
                            int[] tempPitches = new int[notesInBar];
                            double[] tempRhythmValues = new double[notesInBar];
                            for (j = 0; j < notesInBar; ++j) {
                                tempPitches[j] = individual.getNote(j + index).getPitch();
                                tempRhythmValues[j] = individual.getNote(j + index).getRhythmValue();
                            }
                            for (j = 0; j < notesInBar; ++j) {
                                individual.getNote(j + index).setPitch(tempPitches[notesInBar - j - 1]);
                                individual.getNote(j + index).setRhythmValue(tempRhythmValues[notesInBar - j - 1]);
                            }
                        }
                    }
                }
            }
            int n1 = individual.size() - initialSize;
            double n2change2 = (double)(n1 * this.MUTATE_PERCENTAGE[2]) / 100.0;
            int n2change3 = 0;
            n2change3 = n2change2 < 1.0 ? (Math.random() < n2change2 ? 1 : 0) : (int)Math.floor(n2change2);
            Vector vector = (Vector)individual.getNoteList().clone();
            for (int j = 0; j < n2change3; ++j) {
                int r1 = (int)(Math.random() * (double)(n1 - 1));
                Note note5 = (Note)vector.elementAt(initialSize + r1);
                int pitch5 = note5.getPitch();
                double rhythmValue5 = note5.getRhythmValue();
                if (rhythmValue5 >= 1.0 && rhythmValue5 % 1.0 == 0.0 && rhythmValue5 * 2.0 == Math.ceil(rhythmValue5 * 2.0)) {
                    vector.removeElementAt(initialSize + r1);
                    vector.insertElementAt(new Note(pitch5, rhythmValue5 / 2.0), initialSize + r1);
                    vector.insertElementAt(new Note(pitch5, rhythmValue5 / 2.0), initialSize + r1);
                    ++n1;
                    continue;
                }
                double rhythmValue6 = rhythmValue5 + ((Note)vector.elementAt(initialSize + r1 + 1)).getRhythmValue();
                if (!(rhythmValue6 <= 2.0)) continue;
                vector.removeElementAt(initialSize + r1);
                vector.removeElementAt(initialSize + r1);
                vector.insertElementAt(new Note(pitch5, rhythmValue6), initialSize + r1);
                --n1;
            }
            individual.addNoteList(vector, false);
            vector = (Vector)individual.getNoteList().clone();
            int previousPitch = Integer.MIN_VALUE;
            double previousRV = 0.0;
            for (int index1 = initialSize; index1 < vector.size() && previousPitch == Integer.MIN_VALUE; ++index1) {
                previousPitch = ((Note)vector.elementAt(index1)).getPitch();
                previousRV = ((Note)vector.elementAt(index1)).getRhythmValue();
            }
            for (int k = index1; k < vector.size(); ++k) {
                int currentPitch = ((Note)vector.elementAt(k)).getPitch();
                double currentRV = ((Note)vector.elementAt(k)).getRhythmValue();
                if (currentPitch == Integer.MIN_VALUE) continue;
                int interval = currentPitch - previousPitch;
                if ((Math.abs(interval) == 4 || Math.abs(interval) == 3) && Math.random() < (double)this.MUTATE_PERCENTAGE[3] / 100.0) {
                    int scalePitch = 0;
                    if (interval > 0) {
                        scalePitch = currentPitch - 1;
                        if (!this.isScale(scalePitch)) {
                            --scalePitch;
                        }
                    } else {
                        scalePitch = currentPitch + 1;
                        if (!this.isScale(scalePitch)) {
                            ++scalePitch;
                        }
                    }
                    if (currentRV > previousRV) {
                        if (currentRV >= 0.5 && (int)Math.ceil(currentRV * 2.0) == (int)(currentRV * 2.0)) {
                            vector.removeElementAt(k);
                            vector.insertElementAt(new Note(currentPitch, currentRV / 2.0), k);
                            vector.insertElementAt(new Note(scalePitch, currentRV / 2.0), k);
                            ++k;
                        }
                    } else if (previousRV >= 0.5 && (int)Math.ceil(previousRV * 2.0) == (int)(previousRV * 2.0)) {
                        vector.removeElementAt(k - 1);
                        vector.insertElementAt(new Note(scalePitch, previousRV / 2.0), k - 1);
                        vector.insertElementAt(new Note(previousPitch, previousRV / 2.0), k - 1);
                        ++k;
                    }
                }
                previousPitch = currentPitch;
                previousRV = currentRV;
            }
            individual.addNoteList(vector, false);
            individual.addNoteList(this.applyTonalPausesMutation(individual, initialLength, initialSize, beatsPerBar), false);
            double cumulativeRV = 0.0;
            for (int j = initialSize; j < individual.size(); ++j) {
                int pitch = individual.getNote(j).getPitch();
                double rv = individual.getNote(j).getRhythmValue();
                if (pitch != Integer.MIN_VALUE && !this.isScale(pitch)) {
                    if ((int)Math.ceil(cumulativeRV / 2.0) == (int)(cumulativeRV / 2.0)) {
                        if (Math.random() < rv) {
                            if (Math.random() < 0.5) {
                                individual.getNote(j).setPitch(pitch + 1);
                            } else {
                                individual.getNote(j).setPitch(pitch - 1);
                            }
                        }
                    } else if (Math.random() < rv / 2.0) {
                        if (Math.random() < 0.5) {
                            individual.getNote(j).setPitch(pitch + 1);
                        } else {
                            individual.getNote(j).setPitch(pitch - 1);
                        }
                    }
                }
                cumulativeRV += rv;
            }
        }
        return population;
    }

    private void mutate(Note note) {
        int pitchShift = (int)(10.0 / (Math.random() * 6.0 + 2.0));
        if (Math.random() < 0.5) {
            this.shiftPitch(note, pitchShift);
        } else {
            this.shiftPitch(note, 0 - pitchShift);
        }
    }

    private Vector applyTonalPausesMutation(Phrase phrase, double initialLength, int initialSize, int beatsPerBar) {
        Vector vector = (Vector)phrase.getNoteList().clone();
        double rhythmValueCount = initialLength;
        int count = 0;
        for (int j = initialSize; j < phrase.size() - 1; ++j) {
            int pitch = phrase.getNote(j).getPitch();
            int degree = ComplexMutater.pitchToDegree(pitch, 60);
            double rhythmValue = phrase.getNote(j).getRhythmValue() + phrase.getNote(j + 1).getRhythmValue();
            if (rhythmValueCount / (double)beatsPerBar == Math.ceil(rhythmValueCount / (double)beatsPerBar) && (degree == 0 || degree == 7) && Math.random() < 2.0 / rhythmValue * ((double)this.MUTATE_PERCENTAGE[4] / 100.0)) {
                vector.removeElementAt(j - count);
                vector.removeElementAt(j - count);
                vector.insertElementAt(new Note(pitch, rhythmValue), j - count);
                rhythmValueCount += phrase.getNote(j).getRhythmValue();
                ++j;
                ++count;
            }
            rhythmValueCount += phrase.getNote(j).getRhythmValue();
        }
        return vector;
    }

    private void shiftPitch(Note note, int shift) {
        note.setPitch(note.getPitch() + shift);
    }

    private boolean isScale(int pitch) {
        for (int j = 0; j < PhraseAnalysis.MAJOR_SCALE.length; ++j) {
            if (pitch % 12 != PhraseAnalysis.MAJOR_SCALE[j]) continue;
            return true;
        }
        return false;
    }

    public Panel getPanel() {
        return this.panel;
    }

    public String getLabel() {
        return label;
    }

    public void setModifyAll(boolean val) {
        this.modifyAll = val;
    }
}

